/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import java.util.ArrayList;
import java.util.Collection;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.hide.HideTaskFactory;
import org.cytoscape.task.hide.UnHideTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public final class SelectUtils {
    private final CyServiceRegistrar serviceRegistrar;

    public SelectUtils(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void setSelectedNodes(CyNetwork network, Collection<CyNode> nodes, boolean select) {
        this.setSelected(network, nodes, select, network.getDefaultNodeTable());
    }

    public void setSelectedEdges(CyNetwork network, Collection<CyEdge> edges, boolean select) {
        this.setSelected(network, edges, select, network.getDefaultEdgeTable());
    }

    public void setSelectedAnnotations(Collection<Annotation> annotations, boolean select) {
        for (Annotation a : annotations) {
            if (a.isSelected() == select) continue;
            a.setSelected(select);
        }
    }

    private void setSelected(CyNetwork network, Collection<? extends CyIdentifiable> objects, boolean select, CyTable table) {
        Boolean value = select ? Boolean.TRUE : Boolean.FALSE;
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        eventHelper.silenceEventSource((Object)table);
        ArrayList<RowSetRecord> rowsChanged = new ArrayList<RowSetRecord>();
        for (CyIdentifiable cyIdentifiable : objects) {
            CyRow row = cyIdentifiable != null ? table.getRow((Object)cyIdentifiable.getSUID()) : null;
            if (row == null) continue;
            row.set("selected", (Object)value);
            rowsChanged.add(new RowSetRecord(row, "selected", (Object)value, (Object)value));
        }
        eventHelper.unsilenceEventSource((Object)table);
        RowsSetEvent event = new RowsSetEvent(table, rowsChanged);
        eventHelper.fireEvent((CyEvent)event);
    }

    public void setVisible(CyNetworkView networkView, Collection<CyNode> selectedNodes, Collection<CyEdge> selectedEdges) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        HideTaskFactory hideFactory = (HideTaskFactory)this.serviceRegistrar.getService(HideTaskFactory.class);
        TaskIterator hideTasks = hideFactory.createTaskIterator(networkView, (Collection)network.getNodeList(), (Collection)network.getEdgeList());
        UnHideTaskFactory unhideFactory = (UnHideTaskFactory)this.serviceRegistrar.getService(UnHideTaskFactory.class);
        TaskIterator unhideTasks = unhideFactory.createTaskIterator(networkView, selectedNodes, selectedEdges);
        TaskIterator taskIterator = new TaskIterator(new Task[0]);
        taskIterator.append(hideTasks);
        taskIterator.append(unhideTasks);
        SynchronousTaskManager taskManager = (SynchronousTaskManager)this.serviceRegistrar.getService(SynchronousTaskManager.class);
        taskManager.execute(taskIterator);
    }
}

