/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.AbstractSelectTask;
import org.cytoscape.task.internal.utils.NodeAndEdgeTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListSingleSelection;

public class SelectTask
extends AbstractSelectTask
implements ObservableTask {
    private List<CyNode> selectedNodes;
    private List<CyEdge> selectedEdges;
    @ContainsTunables
    public NodeAndEdgeTunable nodesAndEdges;
    @Tunable(description="First neighbors options", longDescription="If this option is anything other than 'none', add nodes to the selection based on the value of the argument.  If 'incoming', add nodes to the selection that have edges pointing to one of the selected nodes.  If 'output', add nodes to the selection that have edges that point to them from one of the selected nodes.  If 'undirected' add any neighbors that have undirected edges connecting to any of the selected nodes. Finally, if 'any', then add all first neighbors to the selection list.", exampleStringValue="none", context="nogui")
    public ListSingleSelection<String> firstNeighbors = new ListSingleSelection((Object[])new String[]{"none", "incoming", "outgoing", "undirected", "any"});
    @Tunable(description="Invert", longDescription="If this option is not 'none', then the selected nodes or edges (or both) will be deselected and all other nodes or edges will be selected", exampleStringValue="none", context="nogui")
    public ListSingleSelection<String> invert = new ListSingleSelection((Object[])new String[]{"none", "nodes", "edges", "both"});
    @Tunable(description="Extend edge selection", longDescription="If 'true', then select any nodes adjacent to any selected edges.  This happens before any inversion", exampleStringValue="false", context="nogui")
    public boolean extendEdges = false;
    @Tunable(description="Select adjacent edges", longDescription="If 'true', then select any edges adjacent to any selected nodes.  This happens before any inversion", exampleStringValue="false", context="nogui")
    public boolean adjacentEdges = false;

    public SelectTask(CyServiceRegistrar serviceRegistrar) {
        super(null, serviceRegistrar);
        this.nodesAndEdges = new NodeAndEdgeTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setProgress(0.0);
        this.network = this.nodesAndEdges.getNetwork();
        HashSet<CyNode> nodes = new HashSet<CyNode>();
        HashSet<CyEdge> edges = new HashSet<CyEdge>();
        List<CyNode> nodeList = this.nodesAndEdges.getNodeList(false);
        List<CyEdge> edgeList = this.nodesAndEdges.getEdgeList(false);
        if (nodeList != null && nodeList.size() > 0) {
            nodes.addAll(nodeList);
        } else {
            nodes.addAll(CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true));
        }
        if (edgeList != null && edgeList.size() > 0) {
            edges.addAll(edgeList);
        } else {
            edges.addAll(CyTableUtil.getEdgesInState((CyNetwork)this.network, (String)"selected", (boolean)true));
        }
        int edgeCount = edges.size();
        int nodeCount = nodes.size();
        if (!((String)this.firstNeighbors.getSelectedValue()).equals("none")) {
            Object type = CyEdge.Type.ANY;
            if (((String)this.firstNeighbors.getSelectedValue()).equals("incoming")) {
                type = CyEdge.Type.INCOMING;
            } else if (((String)this.firstNeighbors.getSelectedValue()).equals("outgoing")) {
                type = CyEdge.Type.OUTGOING;
            } else if (((String)this.firstNeighbors.getSelectedValue()).equals("undirected")) {
                type = CyEdge.Type.UNDIRECTED;
            } else if (((String)this.firstNeighbors.getSelectedValue()).equals("any")) {
                type = CyEdge.Type.ANY;
            } else {
                tm.showMessage(TaskMonitor.Level.ERROR, "Unknown edge type");
                return;
            }
            for (CyNode node : new ArrayList(nodes)) {
                nodes.addAll(this.network.getNeighborList(node, (CyEdge.Type)type));
            }
            tm.showMessage(TaskMonitor.Level.INFO, "Found " + (nodes.size() - nodeCount) + " first neighbors");
            nodeCount = nodes.size();
        }
        if (this.extendEdges) {
            for (CyEdge edge : edges) {
                nodes.add(edge.getSource());
                nodes.add(edge.getTarget());
            }
            tm.showMessage(TaskMonitor.Level.INFO, "Added " + (nodes.size() - nodeCount) + " nodes from selected edges");
            nodeCount = nodes.size();
        }
        if (this.adjacentEdges) {
            for (CyNode node : nodes) {
                edges.addAll(this.network.getAdjacentEdgeList(node, CyEdge.Type.ANY));
            }
            edgeCount = edges.size();
        }
        tm.setProgress(0.2);
        if (((String)this.invert.getSelectedValue()).equals("nodes") || ((String)this.invert.getSelectedValue()).equals("both")) {
            HashSet<CyNode> newNodes = new HashSet<CyNode>();
            for (CyNode node : this.network.getNodeList()) {
                if (nodes.contains(node)) continue;
                newNodes.add(node);
            }
            this.selectUtils.setSelectedNodes(this.network, newNodes, true);
            this.selectUtils.setSelectedNodes(this.network, nodes, false);
            tm.showMessage(TaskMonitor.Level.INFO, "Inverting node selection");
            nodeCount = newNodes.size();
            this.selectedNodes = new ArrayList<CyNode>(newNodes);
        } else {
            this.selectUtils.setSelectedNodes(this.network, nodes, true);
            this.selectedNodes = new ArrayList<CyNode>(nodes);
        }
        if (((String)this.invert.getSelectedValue()).equals("edges") || ((String)this.invert.getSelectedValue()).equals("both")) {
            HashSet<CyEdge> newEdges = new HashSet<CyEdge>();
            for (CyEdge edge : this.network.getEdgeList()) {
                if (edges.contains(edge)) continue;
                newEdges.add(edge);
            }
            this.selectUtils.setSelectedEdges(this.network, newEdges, true);
            this.selectUtils.setSelectedEdges(this.network, edges, false);
            tm.showMessage(TaskMonitor.Level.INFO, "Inverting edge selection");
            edgeCount = newEdges.size();
            this.selectedEdges = new ArrayList<CyEdge>(newEdges);
        } else {
            this.selectUtils.setSelectedEdges(this.network, edges, true);
            this.selectedEdges = new ArrayList<CyEdge>(edges);
        }
        tm.setProgress(0.6);
        tm.showMessage(TaskMonitor.Level.INFO, "Selected " + nodeCount + " nodes and " + edgeCount + " edges.");
        this.updateView();
        tm.setProgress(1.0);
    }

    public Object getResults(Class type) {
        ArrayList<Object> identifiables = new ArrayList<Object>();
        if (this.selectedNodes != null) {
            identifiables.addAll(this.selectedNodes);
        }
        if (this.selectedEdges != null) {
            identifiables.addAll(this.selectedEdges);
        }
        if (type.equals(List.class)) {
            return identifiables;
        }
        if (type.equals(String.class)) {
            if (identifiables.size() == 0) {
                return "<none>";
            }
            Object ret = "";
            if (this.selectedNodes != null && this.selectedNodes.size() > 0) {
                ret = (String)ret + "Nodes selected: \n";
                for (CyNode node : this.selectedNodes) {
                    ret = (String)ret + "   " + (String)this.network.getRow((CyIdentifiable)node).get("name", String.class) + "\n";
                }
            }
            if (this.selectedEdges != null && this.selectedEdges.size() > 0) {
                ret = (String)ret + "Edges selected: \n";
                for (CyEdge edge : this.selectedEdges) {
                    ret = (String)ret + "   " + (String)this.network.getRow((CyIdentifiable)edge).get("name", String.class) + "\n";
                }
            }
            return ret;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (identifiables == null || identifiables.size() == 0) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                Object result = "{\"nodes\":";
                result = this.selectedNodes == null || this.selectedNodes.size() == 0 ? (String)result + "[]" : (String)result + cyJSONUtil.cyIdentifiablesToJson(this.selectedNodes);
                result = (String)result + ", \"edges\":";
                result = this.selectedEdges == null || this.selectedEdges.size() == 0 ? (String)result + "[]" : (String)result + cyJSONUtil.cyIdentifiablesToJson(this.selectedEdges);
                return (String)result + "}";
            };
            return res;
        }
        return identifiables;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, JSONResult.class);
    }
}

