/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import java.util.HashSet;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.AbstractSelectTask;
import org.cytoscape.task.internal.select.SelectionEdit;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class SelectAdjacentEdgesTask
extends AbstractSelectTask {
    public SelectAdjacentEdgesTask(CyNetwork net, CyServiceRegistrar serviceRegistrar) {
        super(net, serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Select Adjacent Edges");
        tm.setProgress(0.0);
        if (this.network == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
            return;
        }
        CyNetworkView view = this.getNetworkView(this.network);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new SelectionEdit("Select Adjacent Edges", this.network, view, SelectionEdit.SelectionFilter.EDGES_ONLY, this.serviceRegistrar));
        tm.setStatusMessage("Selecting Edges...");
        tm.setProgress(0.2);
        HashSet<CyEdge> edgeSet = new HashSet<CyEdge>();
        for (CyNode node : CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true)) {
            edgeSet.addAll(this.network.getAdjacentEdgeList(node, CyEdge.Type.ANY));
        }
        tm.setProgress(0.3);
        this.selectUtils.setSelectedEdges(this.network, edgeSet, true);
        tm.setStatusMessage("Updating View...");
        tm.setProgress(0.9);
        this.updateView();
        tm.setProgress(1.0);
    }
}

