/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.AbstractSelectTask;
import org.cytoscape.task.internal.select.SelectionEdit;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class InvertSelectedEdgesTask
extends AbstractSelectTask {
    public InvertSelectedEdgesTask(CyNetwork net, CyServiceRegistrar serviceRegistrar) {
        super(net, serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Invert Edge Selection");
        tm.setProgress(0.0);
        if (this.network == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
            return;
        }
        CyNetworkView view = this.getNetworkView(this.network);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new SelectionEdit("Invert Selected Edges", this.network, view, SelectionEdit.SelectionFilter.EDGES_ONLY, this.serviceRegistrar));
        tm.setStatusMessage("Inverting Edge Selection...");
        tm.setProgress(0.2);
        for (CyEdge e : this.network.getEdgeList()) {
            if (((Boolean)this.network.getRow((CyIdentifiable)e).get("selected", Boolean.class)).booleanValue()) {
                this.network.getRow((CyIdentifiable)e).set("selected", (Object)false);
                continue;
            }
            this.network.getRow((CyIdentifiable)e).set("selected", (Object)true);
        }
        tm.setStatusMessage("Updating View...");
        tm.setProgress(0.8);
        this.updateView();
        tm.setProgress(1.0);
    }
}

