/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.AbstractSelectTask;
import org.cytoscape.task.internal.utils.NodeAndEdgeTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class DeselectTask
extends AbstractSelectTask
implements ObservableTask {
    private List<CyNode> deselectedNodes;
    private List<CyEdge> deselectedEdges;
    @ContainsTunables
    public NodeAndEdgeTunable nodesAndEdges;

    public DeselectTask(CyServiceRegistrar serviceRegistrar) {
        super(null, serviceRegistrar);
        this.nodesAndEdges = new NodeAndEdgeTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Deselect Nodes and Edges");
        tm.setProgress(0.0);
        CyNetwork network = this.nodesAndEdges.getNetwork();
        if (network == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
            return;
        }
        this.deselectedNodes = this.nodesAndEdges.getNodeList(false);
        this.deselectedEdges = this.nodesAndEdges.getEdgeList(false);
        int edgeCount = 0;
        int nodeCount = 0;
        if (this.deselectedEdges != null && this.deselectedEdges.size() > 0) {
            this.selectUtils.setSelectedEdges(network, this.deselectedEdges, false);
            edgeCount = this.deselectedEdges.size();
        }
        if (this.deselectedNodes != null && this.deselectedNodes.size() > 0) {
            this.selectUtils.setSelectedNodes(network, this.deselectedNodes, false);
            nodeCount = this.deselectedNodes.size();
        }
        tm.setProgress(0.6);
        tm.showMessage(TaskMonitor.Level.INFO, "Deselected " + nodeCount + " nodes and " + edgeCount + " edges.");
        this.updateView();
        tm.setProgress(1.0);
    }

    public Object getResults(Class type) {
        ArrayList<Object> identifiables = new ArrayList<Object>();
        if (this.deselectedNodes != null && this.deselectedNodes.size() > 0) {
            identifiables.addAll(this.deselectedNodes);
        }
        if (this.deselectedEdges != null && this.deselectedEdges.size() > 0) {
            identifiables.addAll(this.deselectedEdges);
        }
        if (type.equals(List.class)) {
            return identifiables;
        }
        if (type.equals(String.class)) {
            if (identifiables.size() == 0) {
                return "<none>";
            }
            Object ret = "";
            if (this.deselectedNodes != null && this.deselectedNodes.size() > 0) {
                ret = (String)ret + "Nodes deselected: \n";
                for (CyNode node : this.deselectedNodes) {
                    ret = (String)ret + "   " + (String)this.network.getRow((CyIdentifiable)node).get("name", String.class) + "\n";
                }
            }
            if (this.deselectedEdges != null && this.deselectedEdges.size() > 0) {
                ret = (String)ret + "Edges deselected: \n";
                for (CyEdge edge : this.deselectedEdges) {
                    ret = (String)ret + "   " + (String)this.network.getRow((CyIdentifiable)edge).get("name", String.class) + "\n";
                }
            }
            return ret;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                if (identifiables == null || identifiables.size() == 0) {
                    return "{}";
                }
                Object result = "{\"nodes\":";
                result = this.deselectedNodes == null || this.deselectedNodes.size() == 0 ? (String)result + "[]" : (String)result + cyJSONUtil.cyIdentifiablesToJson(this.deselectedNodes);
                result = (String)result + ", \"edges\":";
                result = this.deselectedEdges == null || this.deselectedEdges.size() == 0 ? (String)result + "[]" : (String)result + cyJSONUtil.cyIdentifiablesToJson(this.deselectedEdges);
                return (String)result + "}";
            };
            return res;
        }
        return identifiables;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, JSONResult.class);
    }
}

