/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.networkobjects.AbstractPropertyTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.EdgeTunable;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class SetEdgePropertiesTask
extends AbstractPropertyTask {
    @ContainsTunables
    public EdgeTunable edgeTunable;
    @Tunable(description="Whether or not to lock the property", context="nogui", longDescription="Locking a visual property will override any mappings.  This is the same as the ```Bypass``` column in the user interface", exampleStringValue="true")
    public boolean bypass;
    @Tunable(description="Properties to get the value for", context="nogui", longDescription="A list of property names separated by commas. Refer to the 'list properties' command avalable for node, edge and network namespaces.", exampleStringValue="Paint, Visible")
    public String propertyList;
    @Tunable(description="Values to set for the properties", context="nogui", longDescription="A list of values separated by commas.", exampleStringValue="#808080,true")
    public String valueList;

    public SetEdgePropertiesTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.edgeTunable = new EdgeTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        String[] values;
        CyNetwork network = this.edgeTunable.getNetwork();
        if (this.propertyList == null || this.propertyList.length() == 0) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Property list must be specified");
            return;
        }
        if (this.valueList == null || this.valueList.length() == 0) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Value list must be specified");
            return;
        }
        String[] props = this.propertyList.split(",");
        if (props.length != (values = DataUtils.getCSV(this.valueList)).length) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Property list and value list are not the same length");
            return;
        }
        for (CyEdge edge : this.edgeTunable.getEdgeList()) {
            tm.showMessage(TaskMonitor.Level.INFO, "   Setting properties for edge " + DataUtils.getEdgeName(network.getDefaultEdgeTable(), edge));
            int valueIndex = 0;
            for (String property : props) {
                String value = values[valueIndex];
                ++valueIndex;
                try {
                    VisualProperty<?> vp = this.getProperty(network, (CyIdentifiable)edge, property.trim());
                    this.setPropertyValue(network, (CyIdentifiable)edge, vp, value, this.bypass);
                    tm.showMessage(TaskMonitor.Level.INFO, "       " + vp.getDisplayName() + " set to " + value.toString());
                }
                catch (Exception e) {
                    tm.showMessage(TaskMonitor.Level.ERROR, e.getMessage());
                    return;
                }
            }
        }
    }

    public Object getResults(Class type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class);
    }
}

