/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class SetCurrentNetworkTask
extends AbstractTask
implements ObservableTask {
    CyApplicationManager appManager;
    @Tunable(description="Network to make current", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", context="nogui")
    public CyNetwork network;

    public SetCurrentNetworkTask(CyApplicationManager appManager) {
        this.appManager = appManager;
    }

    public void run(TaskMonitor taskMonitor) {
        this.appManager.setCurrentNetwork(this.network);
        taskMonitor.showMessage(TaskMonitor.Level.INFO, "Set current network to " + this.network.toString());
    }

    public Object getResults(Class type) {
        if (type.equals(String.class)) {
            return "Set current network to " + this.network.toString();
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }
}

