/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.task.internal.networkobjects.AbstractGetTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class RenameNodeTask
extends AbstractGetTask {
    @Tunable(description="Network node is in", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;
    @Tunable(description="Node to be renamed", context="nogui", longDescription="Selects a node by name, or, if the parameter has the prefix ```suid:```, selects a node by SUID.", exampleStringValue="suid:123")
    public String node;
    @Tunable(description="New node name", context="nogui", longDescription="New name of the node")
    public String newName;

    public void run(TaskMonitor tm) {
        if (this.network == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
            return;
        }
        if (this.node == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Node name or suid must be specified");
            return;
        }
        if (this.newName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "New name must be specified");
            return;
        }
        CyNode renamedNode = this.getNode(this.network, this.node);
        this.network.getRow((CyIdentifiable)renamedNode).set("name", (Object)this.newName);
        tm.showMessage(TaskMonitor.Level.INFO, "Node " + renamedNode + " renamed to " + this.newName);
    }

    public Object getResults(Class type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class);
    }
}

