/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class ListNetworksTask
extends AbstractTask
implements ObservableTask {
    Set<CyNetwork> networks;
    private final CyServiceRegistrar serviceRegistrar;

    public ListNetworksTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        this.networks = ((CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class)).getNetworkSet();
        tm.showMessage(TaskMonitor.Level.INFO, "Found " + this.networks.size() + " networks.");
    }

    public Object getResults(Class type) {
        if (type.equals(List.class)) {
            return new ArrayList<CyNetwork>(this.networks);
        }
        if (type.equals(Set.class)) {
            return this.networks;
        }
        if (type.equals(String.class)) {
            Object res = "";
            for (CyNetwork network : this.networks) {
                res = (String)res + network.toString() + "\n";
            }
            return ((String)res).substring(0, ((String)res).length() - 1);
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.networks == null || this.networks.size() == 0) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return "{\"networks\":" + cyJSONUtil.cyIdentifiablesToJson(this.networks) + "}";
            };
            return res;
        }
        return this.networks;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, Set.class, String.class, JSONResult.class);
    }
}

