/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.utils.EdgeTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class ListEdgesTask
extends AbstractTask
implements ObservableTask {
    private final CyServiceRegistrar serviceRegistrar;
    List<CyEdge> edges;
    CyNetwork network;
    @ContainsTunables
    public EdgeTunable edgeTunable;

    public ListEdgesTask(CyServiceRegistrar serviceRegistrar) {
        this.edgeTunable = new EdgeTunable(serviceRegistrar);
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        this.network = this.edgeTunable.getNetwork();
        this.edges = this.edgeTunable.getEdgeList();
        if (this.edges == null || this.edges.size() == 0) {
            tm.showMessage(TaskMonitor.Level.WARN, "No edges found");
            return;
        }
        tm.showMessage(TaskMonitor.Level.INFO, "Found " + this.edges.size() + " edges");
    }

    public Object getResults(Class type) {
        if (type.equals(List.class)) {
            return this.edges;
        }
        if (type.equals(String.class)) {
            Object res = "";
            for (CyEdge edge : this.edges) {
                res = (String)res + edge.toString() + " [" + this.getName(this.network, edge) + "]\n";
            }
            return ((String)res).substring(0, ((String)res).length() - 1);
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return "{\"edges\": " + cyJSONUtil.cyIdentifiablesToJson(this.edges) + "}";
            };
            return res;
        }
        return this.edges;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }

    String getName(CyNetwork network, CyEdge edge) {
        return (String)network.getRow((CyIdentifiable)edge).get("name", String.class);
    }
}

