/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.networkobjects.AbstractPropertyTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.NodeTunable;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GetNodePropertiesTask
extends AbstractPropertyTask
implements ObservableTask {
    Map<CyNode, Map<String, AbstractPropertyTask.VisualPropertyObjectTuple>> nodePropertiesMap;
    @ContainsTunables
    public NodeTunable nodeTunable;
    @Tunable(description="Properties to get the value for", context="nogui", longDescription="A list of property names separated by commas. Refer to the 'list properties' command avalable for node, edge and network namespaces.", exampleStringValue="Paint,Visible")
    public String propertyList = null;

    public GetNodePropertiesTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.nodeTunable = new NodeTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        this.nodePropertiesMap = new HashMap<CyNode, Map<String, AbstractPropertyTask.VisualPropertyObjectTuple>>();
        CyNetwork network = this.nodeTunable.getNetwork();
        if (this.propertyList == null || this.propertyList.length() == 0) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Property list must be specified");
            return;
        }
        String[] props = this.propertyList.split(",");
        for (CyNode node : this.nodeTunable.getNodeList()) {
            tm.showMessage(TaskMonitor.Level.INFO, "   Node property values for node " + DataUtils.getNodeName(network.getDefaultNodeTable(), node) + ":");
            HashMap<String, AbstractPropertyTask.VisualPropertyObjectTuple> propertyMap = new HashMap<String, AbstractPropertyTask.VisualPropertyObjectTuple>();
            for (String property : props) {
                try {
                    VisualProperty<?> vp = this.getProperty(network, (CyIdentifiable)node, property.trim());
                    Object value = this.getPropertyValue(network, (CyIdentifiable)node, vp);
                    if (value == null) continue;
                    tm.showMessage(TaskMonitor.Level.INFO, "        " + vp.getDisplayName() + "=" + value.toString());
                    propertyMap.put(vp.getIdString(), new AbstractPropertyTask.VisualPropertyObjectTuple(vp, value));
                }
                catch (Exception e) {
                    tm.showMessage(TaskMonitor.Level.ERROR, e.getMessage());
                    return;
                }
            }
            this.nodePropertiesMap.put(node, propertyMap);
        }
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            Map<CyNode, Map> nodeObjectMap = this.nodePropertiesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e2 -> ((AbstractPropertyTask.VisualPropertyObjectTuple)e2.getValue()).object))));
            return DataUtils.convertMapToString(nodeObjectMap);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> GetNodePropertiesTask.getVisualPropertiesJSON(this.nodePropertiesMap);
            return res;
        }
        if (requestedType.equals(Map.class)) {
            return this.nodePropertiesMap;
        }
        return this.nodePropertiesMap;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(Map.class, String.class, JSONResult.class);
    }
}

