/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.networkobjects.AbstractPropertyTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.EdgeTunable;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GetEdgePropertiesTask
extends AbstractPropertyTask
implements ObservableTask {
    Map<CyEdge, Map<String, AbstractPropertyTask.VisualPropertyObjectTuple>> edgePropertiesMap;
    @ContainsTunables
    public EdgeTunable edgeTunable;
    @Tunable(description="Properties to get the value for", context="nogui", longDescription="A list of property names separated by commas. Refer to the 'list properties' command avalable for node, edge and network namespaces.", exampleStringValue="Paint,Visible")
    public String propertyList = null;

    public GetEdgePropertiesTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.edgeTunable = new EdgeTunable(serviceRegistrar);
    }

    public void run(TaskMonitor taskMonitor) {
        this.edgePropertiesMap = new HashMap<CyEdge, Map<String, AbstractPropertyTask.VisualPropertyObjectTuple>>();
        CyNetwork network = this.edgeTunable.getNetwork();
        if (this.propertyList == null || this.propertyList.length() == 0) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "Property list must be specified");
            return;
        }
        String[] props = this.propertyList.split(",");
        for (CyEdge edge : this.edgeTunable.getEdgeList()) {
            taskMonitor.showMessage(TaskMonitor.Level.INFO, "   Edge property values for edge " + DataUtils.getEdgeName(network.getDefaultEdgeTable(), edge) + ":");
            HashMap<String, AbstractPropertyTask.VisualPropertyObjectTuple> propertyMap = new HashMap<String, AbstractPropertyTask.VisualPropertyObjectTuple>();
            for (String property : props) {
                try {
                    VisualProperty<?> vp = this.getProperty(network, (CyIdentifiable)edge, property.trim());
                    Object value = this.getPropertyValue(network, (CyIdentifiable)edge, vp);
                    if (value == null) continue;
                    taskMonitor.showMessage(TaskMonitor.Level.INFO, "        " + vp.getDisplayName() + "=" + value.toString());
                    propertyMap.put(vp.getIdString(), new AbstractPropertyTask.VisualPropertyObjectTuple(vp, value));
                }
                catch (Exception e) {
                    taskMonitor.showMessage(TaskMonitor.Level.ERROR, e.getMessage());
                    return;
                }
            }
            this.edgePropertiesMap.put(edge, propertyMap);
        }
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            Map<CyEdge, Map> edgeObjectMap = this.edgePropertiesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e2 -> ((AbstractPropertyTask.VisualPropertyObjectTuple)e2.getValue()).object))));
            return DataUtils.convertMapToString(edgeObjectMap);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> GetEdgePropertiesTask.getVisualPropertiesJSON(this.edgePropertiesMap);
            return res;
        }
        if (requestedType.equals(Map.class)) {
            return this.edgePropertiesMap;
        }
        return this.edgePropertiesMap;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(Map.class, String.class, JSONResult.class);
    }
}

