/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.network;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.group.CyGroup;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String X_LOCATION_ATTR = "__xLocation";
    private static final String Y_LOCATION_ATTR = "__yLocation";
    private static final String NETWORK_SUID_ATTR = "__groupNetworks.SUID";
    private static final String ISMETA_EDGE_ATTR = "__isMetaEdge";

    public static Dimension getPosition(CyNetwork net, CyGroup group, Long suid, Class tableClass) {
        CyTable table = group.getGroupNetwork().getTable(tableClass, "HIDDEN");
        CyRow row = table.getRow((Object)suid);
        int index = GroupUtils.getNetworkIndex(row, net);
        Dimension d = GroupUtils.getDimension(row, index);
        return d;
    }

    public static void updatePosition(CyNetwork net, CyGroup group, Long suid, Class tableClass, Dimension location) {
        CyTable table = group.getGroupNetwork().getTable(tableClass, "HIDDEN");
        CyRow row = table.getRow((Object)suid);
        if (!row.isSet(NETWORK_SUID_ATTR)) {
            return;
        }
        List<Long> networkSUIDs = GroupUtils.getList(row, NETWORK_SUID_ATTR, Long.class);
        List<Double> xLocations = GroupUtils.getList(row, X_LOCATION_ATTR, Double.class);
        List<Double> yLocations = GroupUtils.getList(row, Y_LOCATION_ATTR, Double.class);
        int index = networkSUIDs.indexOf(net.getSUID());
        if (index == -1) {
            networkSUIDs.add(net.getSUID());
            xLocations.add(location.getWidth());
            yLocations.add(location.getHeight());
        } else {
            xLocations.set(index, location.getWidth());
            yLocations.set(index, location.getHeight());
        }
        row.set(NETWORK_SUID_ATTR, networkSUIDs);
        row.set(X_LOCATION_ATTR, xLocations);
        row.set(Y_LOCATION_ATTR, yLocations);
    }

    public static void initializePositions(CyNetwork net, CyGroup group, Long suid, Class tableClass) {
        CyTable table = group.getGroupNetwork().getTable(tableClass, "HIDDEN");
        GroupUtils.createListColumnIfNeeded(table, NETWORK_SUID_ATTR, Long.class);
        GroupUtils.createListColumnIfNeeded(table, X_LOCATION_ATTR, Double.class);
        GroupUtils.createListColumnIfNeeded(table, Y_LOCATION_ATTR, Double.class);
        CyRow row = table.getRow((Object)suid);
        row.set(NETWORK_SUID_ATTR, new ArrayList());
        row.set(X_LOCATION_ATTR, new ArrayList());
        row.set(Y_LOCATION_ATTR, new ArrayList());
    }

    public static void updateMetaEdgeInformation(CyNetwork origNet, CyNetwork newNet, CyEdge origEdge, CyEdge newEdge) {
        CyRow origRow;
        if (newEdge == null) {
            return;
        }
        CyRootNetwork newRoot = ((CySubNetwork)newNet).getRootNetwork();
        CyRootNetwork origRoot = ((CySubNetwork)origNet).getRootNetwork();
        CyTable newTable = newRoot.getTable(CyEdge.class, "HIDDEN");
        if (newTable.getColumn(ISMETA_EDGE_ATTR) == null) {
            newTable.createColumn(ISMETA_EDGE_ATTR, Boolean.class, false);
        }
        if ((origRow = origRoot.getRow((CyIdentifiable)origEdge, "HIDDEN")).isSet(ISMETA_EDGE_ATTR)) {
            CyRow newRow = newTable.getRow((Object)newEdge.getSUID());
            Boolean isMeta = (Boolean)origRow.get(ISMETA_EDGE_ATTR, Boolean.class);
            newRow.set(ISMETA_EDGE_ATTR, (Object)isMeta);
        }
    }

    public static void addGroupToNetwork(CyGroup group, CyNetwork origNet, CyNetwork newNet) {
        CyNetwork groupNetwork = group.getGroupNetwork();
        Dimension d = GroupUtils.getPosition(origNet, group, groupNetwork.getSUID(), CyNetwork.class);
        GroupUtils.updatePosition(newNet, group, groupNetwork.getSUID(), CyNetwork.class, d);
        for (CyNode node : group.getNodeList()) {
            Long nodeSUID = node.getSUID();
            d = GroupUtils.getPosition(origNet, group, nodeSUID, CyNode.class);
            GroupUtils.updatePosition(newNet, group, nodeSUID, CyNode.class, d);
            ((CySubNetwork)newNet).addNode(node);
        }
        for (CyEdge edge : group.getInternalEdgeList()) {
            ((CySubNetwork)newNet).addEdge(edge);
        }
        for (CyEdge edge : group.getExternalEdgeList()) {
            ((CySubNetwork)newNet).addEdge(edge);
        }
        group.addGroupToNetwork(newNet);
        group.collapse(newNet);
    }

    private static <T> List<T> getList(CyRow row, String column, Class<T> type) {
        ArrayList l = row.getList(column, type);
        if (l == null) {
            l = new ArrayList();
        }
        return l;
    }

    private static int getNetworkIndex(CyRow row, CyNetwork net) {
        List networkSUIDs;
        if (row.isSet(NETWORK_SUID_ATTR) && (networkSUIDs = row.getList(NETWORK_SUID_ATTR, Long.class)) != null) {
            return networkSUIDs.indexOf(net.getSUID());
        }
        return -1;
    }

    private static Dimension getDimension(CyRow row, int index) {
        if (index == -1) {
            return null;
        }
        List xLocations = row.getList(X_LOCATION_ATTR, Double.class);
        List yLocations = row.getList(Y_LOCATION_ATTR, Double.class);
        if (xLocations == null || yLocations == null) {
            return null;
        }
        Dimension d = new Dimension();
        d.setSize((Double)xLocations.get(index), (Double)yLocations.get(index));
        return d;
    }

    private static void createListColumnIfNeeded(CyTable table, String column, Class<?> clazz) {
        if (table.getColumn(column) != null) {
            return;
        }
        table.createListColumn(column, clazz, false);
    }
}

