/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkCollectionTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class DestroyNetworkTask
extends AbstractNetworkCollectionTask
implements ObservableTask {
    @Tunable(description="<html>The selected networks will be lost.<br />Do you want to continue?</html>", params="ForceSetDirectly=true", context="gui")
    public boolean destroyCurrentNetwork = true;
    @Tunable(description="Network to destroy", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", context="nogui")
    public CyNetwork network;
    private final CyServiceRegistrar serviceRegistrar;
    private List<CyNetwork> localNets;

    public DestroyNetworkTask(Collection<CyNetwork> nets, CyServiceRegistrar serviceRegistrar) {
        super(nets);
        if (nets != null && !nets.isEmpty()) {
            this.localNets = new ArrayList<CyNetwork>(nets);
        }
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        if (this.destroyCurrentNetwork) {
            tm.setTitle("Destroy Network(s)");
            tm.setProgress(0.0);
            CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
            if (this.localNets == null || this.localNets.isEmpty()) {
                if (this.network == null) {
                    tm.showMessage(TaskMonitor.Level.ERROR, "Need to specify network to destroy");
                    return;
                }
                this.localNets = Collections.singletonList(this.network);
            }
            int i = 0;
            int networkCount = this.localNets.size();
            for (CyNetwork n : this.localNets) {
                if (this.cancelled) {
                    return;
                }
                this.destroyNetwork(n, netManager);
                tm.setProgress((double)(++i) / (double)networkCount);
            }
            tm.setProgress(1.0);
        }
    }

    private void destroyNetwork(CyNetwork net, CyNetworkManager netManager) {
        CyRootNetwork rootNet = null;
        CySubNetwork parentNet = null;
        if (net instanceof CySubNetwork) {
            rootNet = ((CySubNetwork)net).getRootNetwork();
            Long suid = DataUtils.getParentNetworkSUID((CySubNetwork)net);
            if (suid != null && netManager.getNetwork(suid.longValue()) instanceof CySubNetwork) {
                parentNet = (CySubNetwork)netManager.getNetwork(suid.longValue());
            }
        }
        netManager.destroyNetwork(net);
        if (net instanceof CySubNetwork) {
            this.updateParentNetworkData(net.getSUID(), rootNet, parentNet != null ? parentNet.getSUID() : null);
        }
    }

    private void updateParentNetworkData(Long destroyedSUID, CyRootNetwork rootNet, Long newParentSUID) {
        for (CySubNetwork sn : rootNet.getSubNetworkList()) {
            if (!destroyedSUID.equals(DataUtils.getParentNetworkSUID(sn))) continue;
            DataUtils.saveParentNetworkSUID(sn, newParentSUID);
        }
    }

    public Object getResults(Class type) {
        if (this.localNets == null) {
            return null;
        }
        if (type.equals(String.class)) {
            Object res = "Destroyed network";
            if (this.localNets.size() > 1) {
                res = (String)res + "s";
            }
            res = (String)res + ":\n";
            for (CyNetwork net : this.localNets) {
                res = (String)res + "    " + net.toString() + "\n";
            }
            return res;
        }
        if (type.equals(CyNetwork.class)) {
            return this.localNets.get(0);
        }
        if (type.equals(List.class)) {
            return this.localNets;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.localNets == null) {
                    return "{}";
                }
                return "{\"network\":" + this.localNets.get(0).getSUID() + "}";
            };
            return res;
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyNetwork.class, List.class, String.class, JSONResult.class);
    }
}

