/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.layout;

import java.util.Collection;
import java.util.Collections;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewCollectionTask;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class ApplyPreferredLayoutTask
extends AbstractNetworkViewCollectionTask {
    @Tunable(description="Network view to apply the layout currently set as default to", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork networkSelected;
    private final CyServiceRegistrar serviceRegistrar;

    public ApplyPreferredLayoutTask(Collection<CyNetworkView> networkViews, CyServiceRegistrar serviceRegistrar) {
        super(networkViews);
        this.serviceRegistrar = serviceRegistrar;
    }

    public ApplyPreferredLayoutTask(CyServiceRegistrar serviceRegistrar) {
        this(Collections.singletonList(((CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView()), serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Apply Preferred Layout");
        tm.setProgress(0.0);
        CyLayoutAlgorithmManager layoutMgr = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
        CyLayoutAlgorithm layout = layoutMgr.getDefaultLayout();
        if (layout == null) {
            throw new IllegalArgumentException("Couldn't find default layout algorithm");
        }
        tm.setStatusMessage("Applying " + layout.getName() + "...");
        Collection views = this.networkViews;
        if (this.networkSelected != null) {
            views = ((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).getNetworkViews(this.networkSelected);
        }
        tm.setProgress(0.1);
        int i = 0;
        int viewCount = views.size();
        for (CyNetworkView view : views) {
            if (this.cancelled) {
                return;
            }
            String layoutAttribute = layoutMgr.getLayoutAttribute(layout, view);
            TaskIterator itr = layout.createTaskIterator(view, layout.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, layoutAttribute);
            if (itr != null) {
                this.insertTasksAfterCurrentTask(itr);
            }
            tm.setProgress((double)(++i) / (double)viewCount);
        }
        tm.setProgress(1.0);
    }

    public Object getResults(Class type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        return null;
    }
}

