/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.hide;

import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTaskFactory;
import org.cytoscape.task.internal.hide.UnHideFromSelectionTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public abstract class AbstractUnHideTaskFactory
extends AbstractNetworkViewTaskFactory {
    private final String description;
    private final boolean unhideNodes;
    private final boolean unhideEdges;
    private final boolean justSelected;
    private final CyServiceRegistrar serviceRegistrar;

    public AbstractUnHideTaskFactory(String description, boolean unhideNodes, boolean unhideEdges, boolean justSelected, CyServiceRegistrar serviceRegistrar) {
        this.description = description;
        this.unhideNodes = unhideNodes;
        this.unhideEdges = unhideEdges;
        this.justSelected = justSelected;
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator(CyNetworkView view) {
        return new TaskIterator(new Task[]{new UnHideFromSelectionTask(this.description, this.unhideNodes, this.unhideEdges, this.justSelected, view, this.serviceRegistrar)});
    }

    public boolean isReady(CyNetworkView networkView) {
        if (super.isReady(networkView)) {
            if (this.unhideNodes && this.hasHiddenNodes(networkView)) {
                return true;
            }
            if (this.unhideEdges && this.hasHiddenEdges(networkView)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasHiddenNodes(CyNetworkView networkView) {
        CyNetworkViewSnapshot snapshot;
        if (networkView.supportsSnapshots() && (snapshot = networkView.createSnapshot()).isTrackedNodeKey((Object)"HIDDEN_NODES")) {
            return snapshot.getTrackedNodeCount((Object)"HIDDEN_NODES") > 0;
        }
        Iterable views = networkView.getNodeViewsIterable();
        return this.hasHidden(views, (VisualProperty<Boolean>)BasicVisualLexicon.NODE_VISIBLE);
    }

    private boolean hasHiddenEdges(CyNetworkView networkView) {
        CyNetworkViewSnapshot snapshot;
        if (networkView.supportsSnapshots() && (snapshot = networkView.createSnapshot()).isTrackedEdgeKey((Object)"HIDDEN_EDGES")) {
            return snapshot.getTrackedEdgeCount((Object)"HIDDEN_EDGES") > 0;
        }
        if (((CyNetwork)networkView.getModel()).getEdgeCount() > 400000) {
            return true;
        }
        Iterable views = networkView.getEdgeViewsIterable();
        return this.hasHidden(views, (VisualProperty<Boolean>)BasicVisualLexicon.EDGE_VISIBLE);
    }

    private <T> boolean hasHidden(Iterable<View<T>> views, VisualProperty<Boolean> vp) {
        for (View<T> v : views) {
            if (!Boolean.FALSE.equals(v.getVisualProperty(vp))) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }
}

