/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.group.AbstractGroupTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class CollapseGroupTask
extends AbstractGroupTask
implements ObservableTask {
    private List<CyGroup> groups;
    private boolean collapse;
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;
    @Tunable(description="List of groups", context="nogui", longDescription="Specifies a list of groups. The keywords ```all```, ```selected```, or ```unselected``` can be used to specify groups by their selection state. ", exampleStringValue="selected")
    public String groupList;

    public CollapseGroupTask(CyNetwork net, List<CyGroup> groups, boolean collapse, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.net = net;
        this.groups = groups;
        this.collapse = collapse;
    }

    public CollapseGroupTask(CyGroupManager manager, boolean collapse, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.net = ((CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        this.collapse = collapse;
    }

    public void run(TaskMonitor tm) throws Exception {
        if (this.network != null) {
            this.net = this.network;
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                return;
            }
        }
        if (this.groups == null && this.groupList == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "List of groups must be specified");
            throw new RuntimeException("List of groups must be specified");
        }
        if (this.groups == null) {
            this.groups = this.getGroupList(tm, this.groupList);
        }
        if (this.groups == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find group " + this.groupList);
            throw new RuntimeException("Can't find group " + this.groupList);
        }
        tm.setProgress(0.0);
        int collapsed = 0;
        for (CyGroup group : this.groups) {
            if (this.collapse) {
                if (group.isInNetwork(this.net) && !group.isCollapsed(this.net)) {
                    ++collapsed;
                    group.collapse(this.net);
                }
            } else if (group.isInNetwork(this.net) && group.isCollapsed(this.net)) {
                ++collapsed;
                group.expand(this.net);
            }
            tm.setProgress(1.0 / (double)this.groups.size());
        }
        if (this.collapse) {
            tm.showMessage(TaskMonitor.Level.INFO, "Collapsed " + collapsed + " groups");
        } else {
            tm.showMessage(TaskMonitor.Level.INFO, "Expanded " + collapsed + " groups");
        }
        tm.setProgress(1.0);
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class, List.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(List.class)) {
            return this.groups;
        }
        if (requestedType.equals(String.class)) {
            if (this.collapse) {
                return "Collapsed groups: " + DataUtils.convertData(this.groups);
            }
            return "Expanded groups: " + DataUtils.convertData(this.groups);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> "{\"groups\": [" + this.getGroupSetString(this.groups) + "]}";
            return res;
        }
        return null;
    }
}

