/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.filter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.model.ValidatableTransformer;
import org.cytoscape.filter.model.ValidationWarning;
import org.cytoscape.io.read.CyTransformerReader;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.Tunable;

public class TransformerJsonTunable {
    @Tunable
    public String json;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NamedTransformer<CyNetwork, CyIdentifiable> getTransformer(String name, CyTransformerReader transformerReader) {
        String wrapper = "[ { \"name\" : \"%s\", \"transformers\" : [ %s ] } ]";
        String fullJson = String.format(wrapper, name, this.json);
        byte[] bytes = fullJson.getBytes();
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            NamedTransformer[] transformers = transformerReader.read((InputStream)in);
            if (transformers == null || transformers.length == 0 || transformers[0] == null) {
                NamedTransformer<CyNetwork, CyIdentifiable> namedTransformer = null;
                return namedTransformer;
            }
            NamedTransformer namedTransformer = transformers[0];
            return namedTransformer;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> validate(NamedTransformer<CyNetwork, CyIdentifiable> namedTransformer) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (Transformer transformer : namedTransformer.getTransformers()) {
            ValidatableTransformer validatableTransformer;
            List warnings;
            if (!(transformer instanceof ValidatableTransformer) || (warnings = (validatableTransformer = (ValidatableTransformer)transformer).validateCreation()) == null || warnings.isEmpty()) continue;
            for (ValidationWarning warning : warnings) {
                errorMessages.add(warning.getWarning());
            }
        }
        return errorMessages;
    }
}

