/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.filter;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.cytoscape.filter.TransformerContainer;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.filter.ContainerTunable;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class ListFiltersTask
extends AbstractTask
implements ObservableTask {
    @ContainsTunables
    public ContainerTunable containerTunable = new ContainerTunable();
    private List<String> filterNames;
    private final CyServiceRegistrar serviceRegistrar;

    public ListFiltersTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) {
        TransformerContainer<CyNetwork, CyIdentifiable> container = this.containerTunable.getContainer(this.serviceRegistrar);
        if (container == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "container type not found: '" + this.containerTunable.getValue() + "'");
            return;
        }
        this.filterNames = container.getNamedTransformers().stream().map(NamedTransformer::getName).collect(Collectors.toList());
    }

    public <R> R getResults(Class<? extends R> type) {
        if (String.class.equals(type)) {
            return type.cast(this.filterNames.stream().collect(Collectors.joining(",")));
        }
        if (List.class.equals(type) || Collection.class.equals(type)) {
            return type.cast(this.filterNames);
        }
        if (JSONResult.class.equals(type)) {
            JSONResult res = () -> new Gson().toJson(this.filterNames);
            return type.cast(res);
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, Collection.class, JSONResult.class);
    }
}

