/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.table;

import java.io.File;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.write.CyTableWriterFactory;
import org.cytoscape.io.write.CyTableWriterManager;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.TunableAbstractCyWriter;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Tunable;

public final class CyTableWriter
extends TunableAbstractCyWriter<CyTableWriterFactory, CyTableWriterManager> {
    private final CyTable table;

    public CyTableWriter(CyTable table, CyServiceRegistrar serviceRegistrar) {
        super((CyTableWriterManager)serviceRegistrar.getService(CyTableWriterManager.class), (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class));
        if (table == null) {
            throw new NullPointerException("Table is null");
        }
        this.table = table;
        List fileTypes = this.options.getPossibleValues();
        Iterator i = fileTypes.iterator();
        while (i.hasNext()) {
            if (!((String)i.next()).contains(".cytable")) continue;
            i.remove();
        }
        this.options.setPossibleValues(fileTypes);
        this.outputFile = this.getSuggestedFile();
    }

    void setDefaultFileFormatUsingFileExt(File file) {
        String ext = FilenameUtils.getExtension((String)file.getName());
        ext = ext.toLowerCase().trim();
        String searchDesc = "*." + ext;
        for (String fileTypeDesc : this.getFileFilterDescriptions()) {
            if (!fileTypeDesc.contains(searchDesc)) continue;
            this.options.setSelectedValue((Object)fileTypeDesc);
            break;
        }
    }

    @Override
    protected CyWriter getWriter(CyFileFilter filter) throws Exception {
        return ((CyTableWriterManager)this.writerManager).getWriter(this.table, filter, (OutputStream)this.outputStream);
    }

    @Override
    @Tunable(description="Save Table as", params="fileCategory=table;input=false", dependsOn="options!=", longDescription="The path of the file to export the table to.  Note that the file will be overwritten if it exists.", exampleStringValue="myfile.csv", gravity=1.1)
    public File getOutputFile() {
        return this.outputFile;
    }

    @ProvidesTitle
    public String getTitle() {
        return "Export Table";
    }

    @Override
    protected String getExportName() {
        return this.table.getTitle();
    }
}

