/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.network;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.network.AbstractLoadNetworkTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public class LoadMultipleNetworksTask
extends AbstractLoadNetworkTask {
    private ListSingleSelection<String> targetColumnList;
    private ListSingleSelection<NetworkViewRenderer> rendererList;
    private final CyRootNetwork rootNetwork;
    private final Map<String, CyNetworkReader> readers;

    public LoadMultipleNetworksTask(Map<String, CyNetworkReader> readers, CyRootNetwork rootNetwork, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.rootNetwork = rootNetwork;
        this.readers = readers;
        this.init();
    }

    @Override
    @ProvidesTitle
    public String getTitle() {
        return "Import Networks from Files";
    }

    @Tunable(description="Node Identifier Mapping Column:", groups={"_Network"}, gravity=1.0)
    public ListSingleSelection<String> getTargetColumnList() {
        return this.targetColumnList;
    }

    public void setTargetColumnList(ListSingleSelection<String> colList) {
        if (colList != this.targetColumnList) {
            this.targetColumnList = colList;
            if (this.targetColumnList.getPossibleValues().contains("shared name")) {
                this.targetColumnList.setSelectedValue((Object)"shared name");
            }
        }
    }

    @Tunable(description="Network View Renderer:", groups={"_Network"}, gravity=2.0)
    public ListSingleSelection<NetworkViewRenderer> getNetworkViewRendererList() {
        return this.rendererList;
    }

    public void setNetworkViewRendererList(ListSingleSelection<NetworkViewRenderer> rendererList) {
        this.rendererList = rendererList;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        if (this.readers == null && this.readers.isEmpty()) {
            throw new IllegalArgumentException("No network reader specified.");
        }
        taskMonitor.setTitle("Import Networks");
        taskMonitor.setProgress(0.0);
        String rootNetName = this.rootNetwork != null ? (String)this.rootNetwork.getRow((CyIdentifiable)this.rootNetwork).get("name", String.class) : null;
        String targetColumn = this.targetColumnList != null ? (String)this.targetColumnList.getSelectedValue() : null;
        NetworkViewRenderer renderer = this.rendererList != null ? (NetworkViewRenderer)this.rendererList.getSelectedValue() : null;
        float total = this.readers.size();
        int count = 1;
        for (Map.Entry<String, CyNetworkReader> entry : this.readers.entrySet()) {
            if (this.cancelled) {
                return;
            }
            CyNetworkReader r = entry.getValue();
            if (r instanceof AbstractCyNetworkReader) {
                ListSingleSelection ls;
                AbstractCyNetworkReader ar = (AbstractCyNetworkReader)r;
                if (rootNetName != null) {
                    ls = new ListSingleSelection(Collections.singletonList(rootNetName));
                    ls.setSelectedValue((Object)rootNetName);
                    ar.setRootNetworkList(ls);
                } else {
                    ar.setRootNetworkList(new ListSingleSelection(Collections.emptyList()));
                    ar.setTargetColumnList(new ListSingleSelection(Collections.emptyList()));
                }
                if (targetColumn != null) {
                    ls = new ListSingleSelection(Collections.singletonList(targetColumn));
                    ls.setSelectedValue((Object)targetColumn);
                    ar.setTargetColumnList(ls);
                }
                if (renderer != null) {
                    ls = new ListSingleSelection(Collections.singletonList(renderer));
                    ls.setSelectedValue((Object)renderer);
                    ar.setNetworkViewRendererList(ls);
                }
            }
            this.name = entry.getKey();
            this.loadNetwork(r);
            taskMonitor.setProgress((double)((float)count / total));
            ++count;
        }
    }

    private void init() {
        if (this.readers != null && this.readers.size() > 1) {
            if (this.rootNetwork != null) {
                this.setTargetColumnList(this.getTargetColumns((CyNetwork)this.rootNetwork));
            } else {
                this.setTargetColumnList((ListSingleSelection<String>)new ListSingleSelection((Object[])new String[0]));
            }
            ArrayList renderers = new ArrayList();
            NetworkViewRenderer defViewRenderer = null;
            CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
            Set rendererSet = applicationManager.getNetworkViewRendererSet();
            if (rendererSet.size() > 1) {
                renderers.addAll(rendererSet);
                Collections.sort(renderers, new Comparator<NetworkViewRenderer>(){

                    @Override
                    public int compare(NetworkViewRenderer r1, NetworkViewRenderer r2) {
                        return r1.toString().compareToIgnoreCase(r2.toString());
                    }
                });
            }
            defViewRenderer = applicationManager.getDefaultNetworkViewRenderer();
            this.rendererList = new ListSingleSelection(renderers);
            if (defViewRenderer != null && renderers.contains(defViewRenderer)) {
                this.rendererList.setSelectedValue((Object)defViewRenderer);
            }
        }
    }

    private final ListSingleSelection<String> getTargetColumns(CyNetwork network) {
        CyTable selectedTable = network.getTable(CyNode.class, "SHARED_ATTRS");
        ArrayList<String> colNames = new ArrayList<String>();
        for (CyColumn col : selectedTable.getColumns()) {
            if (col.getName().equalsIgnoreCase("SUID") || col.getName().endsWith(".SUID") || col.getType() != String.class && col.getType() != Integer.class && col.getType() != Long.class) continue;
            colNames.add(col.getName());
        }
        if (colNames.isEmpty() || colNames.size() == 1 && colNames.contains("shared name")) {
            return new ListSingleSelection((Object[])new String[0]);
        }
        this.sort(colNames);
        return new ListSingleSelection(colNames);
    }

    private void sort(List<String> names) {
        if (!names.isEmpty()) {
            final Collator collator = Collator.getInstance(Locale.getDefault());
            Collections.sort(names, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if (s1 == null && s2 == null) {
                        return 0;
                    }
                    if (s1 == null) {
                        return -1;
                    }
                    if (s2 == null) {
                        return 1;
                    }
                    return collator.compare(s1, s2);
                }
            });
        }
    }
}

