/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.xgmml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.cytoscape.io.internal.read.xgmml.ObjectTypeMap;
import org.cytoscape.io.internal.util.UnrecognizedVisualPropertyManager;
import org.cytoscape.io.internal.write.xgmml.GenericXGMMLWriter;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class SessionXGMMLNetworkViewWriter
extends GenericXGMMLWriter {
    public SessionXGMMLNetworkViewWriter(OutputStream outputStream, CyNetworkView networkView, UnrecognizedVisualPropertyManager unrecognizedVisualPropertyMgr, CyServiceRegistrar serviceRegistrar) {
        super(outputStream, networkView, unrecognizedVisualPropertyMgr, null, serviceRegistrar);
    }

    @Override
    protected void writeRootElementAtributes() throws IOException {
        RenderingEngineManager renderingEngineMgr;
        Collection renderingEngines;
        this.writeAttributePair("id", this.networkView.getSUID());
        this.writeAttributePair("label", this.getLabel(this.networkView));
        this.writeAttributePair("cy:view", ObjectTypeMap.toXGMMLBoolean(true));
        this.writeAttributePair("cy:networkId", this.network.getSUID());
        if (this.visualStyle != null) {
            this.writeAttributePair("cy:visualStyle", this.visualStyle.getTitle());
        }
        if ((renderingEngines = (renderingEngineMgr = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class)).getRenderingEngines((View)this.networkView)) != null && !renderingEngines.isEmpty()) {
            this.writeAttributePair("cy:rendererId", ((RenderingEngine)renderingEngines.iterator().next()).getRendererId());
        }
    }

    @Override
    protected void writeMetadata() throws IOException {
    }

    @Override
    protected void writeRootGraphAttributes() throws IOException {
        this.writeGraphics((View<? extends CyIdentifiable>)this.networkView, true);
    }

    @Override
    protected void writeNodes() throws IOException {
        for (View view : this.networkView.getNodeViews()) {
            this.writeNodeView((CyNetwork)this.networkView.getModel(), (View<CyNode>)view);
        }
    }

    @Override
    protected void writeEdges() throws IOException {
        for (View view : this.networkView.getEdgeViews()) {
            this.writeEdgeView((CyNetwork)this.networkView.getModel(), (View<CyEdge>)view);
        }
    }

    @Override
    protected boolean ignoreGraphicsAttribute(CyIdentifiable element, String attName) {
        boolean b = element instanceof CyNode && !attName.matches("x|y|z");
        b = b || element instanceof CyEdge;
        b = b || element instanceof CyNetwork && attName.matches(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT.getIdString());
        return b;
    }

    private void writeNodeView(CyNetwork network, View<CyNode> view) throws IOException {
        this.writeElement("<node");
        this.writeAttributePair("id", view.getSUID());
        this.writeAttributePair("label", this.getLabel(network, (CyIdentifiable)view.getModel()));
        this.writeAttributePair("cy:nodeId", ((CyNode)view.getModel()).getSUID());
        this.write(">\n");
        ++this.depth;
        this.writeGraphics(view, true);
        --this.depth;
        this.writeElement("</node>\n");
    }

    private void writeEdgeView(CyNetwork network, View<CyEdge> view) throws IOException {
        boolean hasLockedVisualProps = false;
        Collection visualProperties = this.getVisualLexicon().getAllDescendants(BasicVisualLexicon.EDGE);
        for (VisualProperty vp : visualProperties) {
            if (!view.isDirectlyLocked(vp)) continue;
            hasLockedVisualProps = true;
            break;
        }
        if (hasLockedVisualProps) {
            this.writeElement("<edge");
            this.writeAttributePair("id", view.getSUID());
            this.writeAttributePair("label", this.getLabel(network, (CyIdentifiable)view.getModel()));
            this.writeAttributePair("cy:edgeId", ((CyEdge)view.getModel()).getSUID());
            this.write(">\n");
            ++this.depth;
            this.writeGraphics(view, true);
            --this.depth;
            this.writeElement("</edge>\n");
        }
    }
}

