/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write.vizmap;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.cytoscape.io.internal.util.vizmap.VisualStyleSerializer;
import org.cytoscape.io.internal.util.vizmap.model.Vizmap;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class VizmapWriterImpl
extends AbstractTask
implements CyWriter {
    private static final String VIZMAP_VERSION = "3.1";
    private final OutputStream outputStream;
    private final VisualStyleSerializer visualStyleSerializer;
    private final Set<VisualStyle> networkStyles;
    private final Set<VisualStyle> tableStyles;

    public VizmapWriterImpl(OutputStream outputStream, VisualStyleSerializer visualStyleSerializer, Set<VisualStyle> networkStyles, Set<VisualStyle> tableStyles) {
        this.outputStream = outputStream;
        this.visualStyleSerializer = visualStyleSerializer;
        this.networkStyles = networkStyles;
        this.tableStyles = tableStyles;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setProgress(0.0);
        JAXBContext jc = JAXBContext.newInstance((String)Vizmap.class.getPackage().getName(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        Marshaller m = jc.createMarshaller();
        taskMonitor.setProgress(0.2);
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd-HH_mm");
        String now = df.format(new Date());
        String vizmapDocId = "VizMap-" + now;
        taskMonitor.setProgress(0.2);
        Vizmap vizmap = this.visualStyleSerializer.createVizmap(this.networkStyles, this.tableStyles);
        vizmap.setId(vizmapDocId);
        vizmap.setDocumentVersion(VIZMAP_VERSION);
        taskMonitor.setProgress(0.4);
        m.marshal((Object)vizmap, this.outputStream);
        taskMonitor.setProgress(1.0);
    }
}

