/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.write;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.write.CyWriterFactory;
import org.cytoscape.io.write.CyWriterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractWriterManager<T extends CyWriterFactory>
implements CyWriterManager<T> {
    protected final DataCategory category;
    protected final Map<CyFileFilter, T> factories;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public AbstractWriterManager(DataCategory category) {
        this.category = category;
        this.factories = new ConcurrentHashMap<CyFileFilter, T>(16, 0.75f, 2);
    }

    public List<CyFileFilter> getAvailableWriterFilters() {
        return new ArrayList<CyFileFilter>(this.factories.keySet());
    }

    public void addCyWriterFactory(T factory, Map<String, String> props) {
        if (factory != null && factory.getFileFilter().getDataCategory() == this.category) {
            logger.debug("adding IO taskFactory ");
            this.factories.put(factory.getFileFilter(), factory);
        } else {
            logger.warn("Specified factory is null or has wrong DataCategory (" + this.category + ")");
        }
    }

    public void removeCyWriterFactory(T factory, Map<String, String> props) {
        this.factories.remove(factory.getFileFilter());
    }

    public T getMatchingFactory(CyFileFilter filter) {
        for (CyWriterFactory factory : this.factories.values()) {
            CyFileFilter cff = factory.getFileFilter();
            if (!filter.equals(cff)) continue;
            logger.debug("found factory for file filter: " + filter.toString());
            return (T)factory;
        }
        logger.warn("Couldn't find matching factory for filter: " + filter.toString());
        return null;
    }
}

