/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util.vizmap;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.cytoscape.io.internal.util.vizmap.CalculatorConverter;
import org.cytoscape.io.internal.util.vizmap.CalculatorConverterFactory;
import org.cytoscape.io.internal.util.vizmap.model.AttributeType;
import org.cytoscape.io.internal.util.vizmap.model.Cell;
import org.cytoscape.io.internal.util.vizmap.model.ContinuousMapping;
import org.cytoscape.io.internal.util.vizmap.model.ContinuousMappingPoint;
import org.cytoscape.io.internal.util.vizmap.model.Dependency;
import org.cytoscape.io.internal.util.vizmap.model.DiscreteMapping;
import org.cytoscape.io.internal.util.vizmap.model.DiscreteMappingEntry;
import org.cytoscape.io.internal.util.vizmap.model.Edge;
import org.cytoscape.io.internal.util.vizmap.model.Network;
import org.cytoscape.io.internal.util.vizmap.model.Node;
import org.cytoscape.io.internal.util.vizmap.model.PassthroughMapping;
import org.cytoscape.io.internal.util.vizmap.model.TableColumnStyle;
import org.cytoscape.io.internal.util.vizmap.model.VisualProperty;
import org.cytoscape.io.internal.util.vizmap.model.VisualStyle;
import org.cytoscape.io.internal.util.vizmap.model.Vizmap;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.Visualizable;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualStyleSerializer {
    private final CalculatorConverterFactory calculatorConverterFactory;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public VisualStyleSerializer(CalculatorConverterFactory calculatorConverterFactory, CyServiceRegistrar serviceRegistrar) {
        this.calculatorConverterFactory = calculatorConverterFactory;
        this.serviceRegistrar = serviceRegistrar;
    }

    public Vizmap createVizmap(Collection<org.cytoscape.view.vizmap.VisualStyle> networkStyles, Collection<org.cytoscape.view.vizmap.VisualStyle> tableStyles) {
        Object vsModel;
        VisualLexicon lexicon;
        Vizmap vizmap = new Vizmap();
        RenderingEngineManager renderingEngineManager = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
        if (networkStyles != null) {
            lexicon = renderingEngineManager.getDefaultVisualLexicon();
            for (org.cytoscape.view.vizmap.VisualStyle style : networkStyles) {
                vsModel = new VisualStyle();
                vizmap.getVisualStyle().add((VisualStyle)vsModel);
                ((VisualStyle)vsModel).setName(style.getTitle());
                ((VisualStyle)vsModel).setNetwork(new Network());
                ((VisualStyle)vsModel).setNode(new Node());
                ((VisualStyle)vsModel).setEdge(new Edge());
                this.createVizmapProperties(style, lexicon, (org.cytoscape.view.model.VisualProperty<Visualizable>)BasicVisualLexicon.NETWORK, ((VisualStyle)vsModel).getNetwork().getVisualProperty());
                this.createVizmapProperties(style, lexicon, (org.cytoscape.view.model.VisualProperty<Visualizable>)BasicVisualLexicon.NODE, ((VisualStyle)vsModel).getNode().getVisualProperty());
                this.createVizmapProperties(style, lexicon, (org.cytoscape.view.model.VisualProperty<Visualizable>)BasicVisualLexicon.EDGE, ((VisualStyle)vsModel).getEdge().getVisualProperty());
                this.createDependencies(style, (VisualStyle)vsModel, lexicon);
            }
        }
        if (tableStyles != null) {
            lexicon = renderingEngineManager.getDefaultTableVisualLexicon();
            for (org.cytoscape.view.vizmap.VisualStyle style : tableStyles) {
                vsModel = new TableColumnStyle();
                vizmap.getTableColumnStyle().add((TableColumnStyle)vsModel);
                ((TableColumnStyle)vsModel).setName(style.getTitle());
                ((TableColumnStyle)vsModel).setCell(new Cell());
                this.createVizmapProperties(style, lexicon, (org.cytoscape.view.model.VisualProperty<Visualizable>)BasicTableVisualLexicon.CELL, ((TableColumnStyle)vsModel).getCell().getVisualProperty());
                this.createDependencies(style, (TableColumnStyle)vsModel, lexicon);
            }
        }
        return vizmap;
    }

    public Set<org.cytoscape.view.vizmap.VisualStyle> createNetworkVisualStyles(Vizmap vizmap) {
        HashSet<org.cytoscape.view.vizmap.VisualStyle> styles = new HashSet<org.cytoscape.view.vizmap.VisualStyle>();
        RenderingEngineManager renderingEngineManager = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
        VisualLexicon lexicon = renderingEngineManager.getDefaultVisualLexicon();
        if (lexicon == null) {
            logger.warn("Cannot create visual styles because there is no default Visual Lexicon");
            return styles;
        }
        if (vizmap != null) {
            VisualStyleFactory visualStyleFactory = (VisualStyleFactory)this.serviceRegistrar.getService(VisualStyleFactory.class);
            for (VisualStyle vsModel : vizmap.getVisualStyle()) {
                org.cytoscape.view.vizmap.VisualStyle vs = visualStyleFactory.createVisualStyle(vsModel.getName());
                if (vsModel.getNetwork() != null) {
                    this.createVisualProperties(vs, lexicon, CyNetwork.class, vsModel.getNetwork().getVisualProperty());
                }
                if (vsModel.getNode() != null) {
                    this.createVisualProperties(vs, lexicon, CyNode.class, vsModel.getNode().getVisualProperty());
                }
                if (vsModel.getEdge() != null) {
                    this.createVisualProperties(vs, lexicon, CyEdge.class, vsModel.getEdge().getVisualProperty());
                }
                this.restoreDependencies(vs, vsModel);
                styles.add(vs);
            }
        }
        return styles;
    }

    public Set<org.cytoscape.view.vizmap.VisualStyle> createTableVisualStyles(Vizmap vizmap) {
        HashSet<org.cytoscape.view.vizmap.VisualStyle> styles = new HashSet<org.cytoscape.view.vizmap.VisualStyle>();
        RenderingEngineManager renderingEngineManager = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
        VisualLexicon lexicon = renderingEngineManager.getDefaultTableVisualLexicon();
        if (lexicon == null) {
            logger.warn("Cannot create visual styles because there is no default Visual Lexicon");
            return styles;
        }
        if (vizmap != null) {
            VisualStyleFactory visualStyleFactory = (VisualStyleFactory)this.serviceRegistrar.getService(VisualStyleFactory.class);
            for (TableColumnStyle vsModel : vizmap.getTableColumnStyle()) {
                org.cytoscape.view.vizmap.VisualStyle vs = visualStyleFactory.createVisualStyle(vsModel.getName());
                if (vsModel.getCell() != null) {
                    this.createVisualProperties(vs, lexicon, CyColumn.class, vsModel.getCell().getVisualProperty());
                }
                this.restoreDependencies(vs, vsModel);
                styles.add(vs);
            }
        }
        return styles;
    }

    public Set<org.cytoscape.view.vizmap.VisualStyle> createVisualStyles(Properties props) {
        Vizmap vizmap = new Vizmap();
        List<VisualStyle> vizmapStyles = vizmap.getVisualStyle();
        HashMap<String, HashMap<String, String>> styleNamesMap = new HashMap<String, HashMap<String, String>>();
        Set<String> propNames = props.stringPropertyNames();
        for (String string : propNames) {
            String value = props.getProperty(string);
            String styleName = CalculatorConverter.parseStyleName(string);
            if (styleName == null) continue;
            HashMap<String, String> keyValueMap = (HashMap<String, String>)styleNamesMap.get(styleName);
            if (keyValueMap == null) {
                keyValueMap = new HashMap<String, String>();
                styleNamesMap.put(styleName, keyValueMap);
            }
            keyValueMap.put(string, value);
        }
        for (Map.Entry entry : styleNamesMap.entrySet()) {
            String styleName = (String)entry.getKey();
            VisualStyle vs = new VisualStyle();
            vs.setName(styleName);
            vs.setNetwork(new Network());
            vs.setNode(new Node());
            vs.setEdge(new Edge());
            Map vsProps = (Map)entry.getValue();
            for (Map.Entry p : vsProps.entrySet()) {
                String key = (String)p.getKey();
                String value = (String)p.getValue();
                Set<CalculatorConverter> convs = this.calculatorConverterFactory.getConverters(key);
                for (CalculatorConverter c : convs) {
                    c.convert(vs, value, props);
                }
            }
            vizmapStyles.add(vs);
        }
        return this.createNetworkVisualStyles(vizmap);
    }

    private void createVizmapProperties(org.cytoscape.view.vizmap.VisualStyle vs, VisualLexicon lexicon, org.cytoscape.view.model.VisualProperty<Visualizable> root, List<VisualProperty> vpModelList) {
        Collection vpList = lexicon.getAllDescendants(root);
        for (org.cytoscape.view.model.VisualProperty vp : vpList) {
            try {
                AttributeType attrType;
                if (root == BasicVisualLexicon.NETWORK && vp.getTargetDataType() != CyNetwork.class) continue;
                Object defValue = vs.getDefaultValue(vp);
                VisualMappingFunction mapping = vs.getVisualMappingFunction(vp);
                if (defValue == null && mapping == null) continue;
                VisualProperty vpModel = new VisualProperty();
                vpModel.setName(vp.getIdString());
                vpModelList.add(vpModel);
                try {
                    String sValue;
                    if (defValue != null && (sValue = vp.toSerializableString(defValue)) != null) {
                        vpModel.setDefault(sValue);
                    }
                }
                catch (Exception e) {
                    System.out.println("CCE in VisualStyleSerielizer");
                }
                if (mapping instanceof org.cytoscape.view.vizmap.mappings.PassthroughMapping) {
                    org.cytoscape.view.vizmap.mappings.PassthroughMapping pm = (org.cytoscape.view.vizmap.mappings.PassthroughMapping)mapping;
                    attrType = VisualStyleSerializer.toAttributeType(pm.getMappingColumnType());
                    PassthroughMapping pmModel = new PassthroughMapping();
                    pmModel.setAttributeName(pm.getMappingColumnName());
                    pmModel.setAttributeType(attrType);
                    vpModel.setPassthroughMapping(pmModel);
                    continue;
                }
                if (mapping instanceof org.cytoscape.view.vizmap.mappings.DiscreteMapping) {
                    org.cytoscape.view.vizmap.mappings.DiscreteMapping dm = (org.cytoscape.view.vizmap.mappings.DiscreteMapping)mapping;
                    attrType = VisualStyleSerializer.toAttributeType(dm.getMappingColumnType());
                    DiscreteMapping dmModel = new DiscreteMapping();
                    dmModel.setAttributeName(dm.getMappingColumnName());
                    dmModel.setAttributeType(attrType);
                    Map map = dm.getAll();
                    for (Map.Entry entry : map.entrySet()) {
                        Object value = entry.getValue();
                        if (value == null) continue;
                        try {
                            DiscreteMappingEntry entryModel = new DiscreteMappingEntry();
                            entryModel.setAttributeValue(entry.getKey().toString());
                            entryModel.setValue(vp.toSerializableString(value));
                            dmModel.getDiscreteMappingEntry().add(entryModel);
                        }
                        catch (Exception e) {
                            logger.warn("Could not add Discrete Mapping entry: " + value, (Throwable)e);
                        }
                    }
                    vpModel.setDiscreteMapping(dmModel);
                    continue;
                }
                if (!(mapping instanceof org.cytoscape.view.vizmap.mappings.ContinuousMapping)) continue;
                org.cytoscape.view.vizmap.mappings.ContinuousMapping cm = (org.cytoscape.view.vizmap.mappings.ContinuousMapping)mapping;
                attrType = VisualStyleSerializer.toAttributeType(cm.getMappingColumnType());
                ContinuousMapping cmModel = new ContinuousMapping();
                cmModel.setAttributeName(cm.getMappingColumnName());
                cmModel.setAttributeType(attrType);
                List points = cm.getAllPoints();
                for (Map.Entry point : points) {
                    org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint continuousPoint = (org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint)point;
                    ContinuousMappingPoint pModel = new ContinuousMappingPoint();
                    Object originalValue = continuousPoint.getValue();
                    String sValue = originalValue.toString();
                    BigDecimal value = new BigDecimal(sValue);
                    pModel.setAttrValue(value);
                    Object lesser = continuousPoint.getRange().lesserValue;
                    Object equal = continuousPoint.getRange().equalValue;
                    Object greater = continuousPoint.getRange().greaterValue;
                    pModel.setLesserValue(vp.toSerializableString(lesser));
                    pModel.setEqualValue(vp.toSerializableString(equal));
                    pModel.setGreaterValue(vp.toSerializableString(greater));
                    cmModel.getContinuousMappingPoint().add(pModel);
                }
                vpModel.setContinuousMapping(cmModel);
            }
            catch (Exception e) {
                logger.error("Cannot save visual property: " + (vp != null ? vp.getDisplayName() : ""), (Throwable)e);
            }
        }
    }

    private <K, V> void createVisualProperties(org.cytoscape.view.vizmap.VisualStyle vs, VisualLexicon lexicon, Class<? extends CyIdentifiable> targetType, List<VisualProperty> vpModelList) {
        for (VisualProperty vpModel : vpModelList) {
            Object attrValue;
            AttributeType attrType;
            String attrName;
            String vpId = vpModel.getName();
            String defValue = vpModel.getDefault();
            org.cytoscape.view.model.VisualProperty vp = lexicon.lookup(targetType, vpId);
            if (vp == null) continue;
            if (defValue != null) {
                V value = this.parseValue(defValue, vp);
                vs.setDefaultValue(vp, value);
            }
            if (vpModel.getPassthroughMapping() != null) {
                PassthroughMapping pmModel = vpModel.getPassthroughMapping();
                attrName = pmModel.getAttributeName();
                attrType = pmModel.getAttributeType();
                Class columnDataType = attrType == AttributeType.BOOLEAN ? Boolean.class : (attrType == AttributeType.FLOAT ? Double.class : (attrType == AttributeType.INTEGER ? Integer.class : (attrType == AttributeType.LONG ? Long.class : (attrType == AttributeType.LIST ? List.class : String.class))));
                try {
                    VisualMappingFunctionFactory pmFactory = (VisualMappingFunctionFactory)this.serviceRegistrar.getService(VisualMappingFunctionFactory.class, "(mapping.type=passthrough)");
                    org.cytoscape.view.vizmap.mappings.PassthroughMapping pm = (org.cytoscape.view.vizmap.mappings.PassthroughMapping)pmFactory.createVisualMappingFunction(attrName, columnDataType, vp);
                    vs.addVisualMappingFunction((VisualMappingFunction)pm);
                }
                catch (Throwable e) {
                    logger.error("Cannot create PassthroughMapping (style=" + vs.getTitle() + ", property=" + vp.getIdString() + ")", e);
                }
                continue;
            }
            if (vpModel.getDiscreteMapping() != null) {
                DiscreteMapping dmModel = vpModel.getDiscreteMapping();
                attrName = dmModel.getAttributeName();
                attrType = dmModel.getAttributeType();
                try {
                    Class attrClass = null;
                    switch (attrType) {
                        case BOOLEAN: {
                            attrClass = Boolean.class;
                            break;
                        }
                        case FLOAT: {
                            attrClass = Double.class;
                            break;
                        }
                        case INTEGER: {
                            attrClass = Integer.class;
                            break;
                        }
                        case LONG: {
                            attrClass = Long.class;
                            break;
                        }
                        default: {
                            attrClass = String.class;
                        }
                    }
                    VisualMappingFunctionFactory dmFactory = (VisualMappingFunctionFactory)this.serviceRegistrar.getService(VisualMappingFunctionFactory.class, "(mapping.type=discrete)");
                    org.cytoscape.view.vizmap.mappings.DiscreteMapping dm = (org.cytoscape.view.vizmap.mappings.DiscreteMapping)dmFactory.createVisualMappingFunction(attrName, attrClass, vp);
                    for (DiscreteMappingEntry entryModel : dmModel.getDiscreteMappingEntry()) {
                        V vpValue;
                        String sAttrValue = entryModel.getAttributeValue();
                        String sValue = entryModel.getValue();
                        if (sAttrValue == null || sValue == null) continue;
                        attrValue = null;
                        switch (attrType) {
                            case BOOLEAN: {
                                attrValue = Boolean.parseBoolean(sAttrValue);
                                break;
                            }
                            case FLOAT: {
                                attrValue = Double.parseDouble(sAttrValue);
                                break;
                            }
                            case INTEGER: {
                                attrValue = Integer.parseInt(sAttrValue);
                                break;
                            }
                            case LONG: {
                                attrValue = Long.parseLong(sAttrValue);
                                break;
                            }
                            default: {
                                attrValue = sAttrValue;
                            }
                        }
                        if ((vpValue = this.parseValue(sValue, vp)) == null) continue;
                        dm.putMapValue(attrValue, vpValue);
                    }
                    vs.addVisualMappingFunction((VisualMappingFunction)dm);
                }
                catch (Throwable e) {
                    logger.error("Cannot create DiscreteMapping (style=" + vs.getTitle() + ", property=" + vp.getIdString() + ")", e);
                }
                continue;
            }
            if (vpModel.getContinuousMapping() == null) continue;
            ContinuousMapping cmModel = vpModel.getContinuousMapping();
            attrName = cmModel.getAttributeName();
            try {
                VisualMappingFunctionFactory cmFactory = (VisualMappingFunctionFactory)this.serviceRegistrar.getService(VisualMappingFunctionFactory.class, "(mapping.type=continuous)");
                org.cytoscape.view.vizmap.mappings.ContinuousMapping cm = (org.cytoscape.view.vizmap.mappings.ContinuousMapping)cmFactory.createVisualMappingFunction(attrName, Number.class, vp);
                for (ContinuousMappingPoint pModel : cmModel.getContinuousMappingPoint()) {
                    V lesser = this.parseValue(pModel.getLesserValue(), vp);
                    V equal = this.parseValue(pModel.getEqualValue(), vp);
                    V greater = this.parseValue(pModel.getGreaterValue(), vp);
                    BoundaryRangeValues brv = new BoundaryRangeValues(lesser, equal, greater);
                    attrValue = pModel.getAttrValue().doubleValue();
                    cm.addPoint(attrValue, brv);
                }
                vs.addVisualMappingFunction((VisualMappingFunction)cm);
            }
            catch (Throwable e) {
                logger.error("Cannot create ContinuousMapping (style=" + vs.getTitle() + ", property=" + vp.getIdString() + ")", e);
            }
        }
    }

    private void createDependencies(org.cytoscape.view.vizmap.VisualStyle visualStyle, VisualStyle vsModel, VisualLexicon lexicon) {
        Set dependencies = visualStyle.getAllVisualPropertyDependencies();
        List<Dependency> nodeDep = vsModel.getNode().getDependency();
        List<Dependency> edgeDep = vsModel.getEdge().getDependency();
        List<Dependency> networkDep = vsModel.getNetwork().getDependency();
        Collection nodeVisualProperties = lexicon.getAllDescendants(BasicVisualLexicon.NODE);
        Collection edgeVisualProperties = lexicon.getAllDescendants(BasicVisualLexicon.EDGE);
        for (VisualPropertyDependency vpDep : dependencies) {
            try {
                Dependency newDependency = new Dependency();
                newDependency.setName(vpDep.getIdString());
                newDependency.setValue(vpDep.isDependencyEnabled());
                org.cytoscape.view.model.VisualProperty parent = vpDep.getParentVisualProperty();
                if (nodeVisualProperties.contains(parent)) {
                    nodeDep.add(newDependency);
                    continue;
                }
                if (edgeVisualProperties.contains(parent)) {
                    edgeDep.add(newDependency);
                    continue;
                }
                networkDep.add(newDependency);
            }
            catch (Exception e) {
                logger.error("Cannot save dependency: " + (vpDep != null ? vpDep.getDisplayName() : ""), (Throwable)e);
            }
        }
    }

    private void createDependencies(org.cytoscape.view.vizmap.VisualStyle visualStyle, TableColumnStyle vsModel, VisualLexicon lexicon) {
        Set dependencies = visualStyle.getAllVisualPropertyDependencies();
        List<Dependency> colDep = vsModel.getCell().getDependency();
        Collection colVisualProperties = lexicon.getAllDescendants(BasicTableVisualLexicon.CELL);
        for (VisualPropertyDependency vpDep : dependencies) {
            try {
                Dependency newDependency = new Dependency();
                newDependency.setName(vpDep.getIdString());
                newDependency.setValue(vpDep.isDependencyEnabled());
                org.cytoscape.view.model.VisualProperty parent = vpDep.getParentVisualProperty();
                if (!colVisualProperties.contains(parent)) continue;
                colDep.add(newDependency);
            }
            catch (Exception e) {
                logger.error("Cannot save dependency: " + (vpDep != null ? vpDep.getDisplayName() : ""), (Throwable)e);
            }
        }
    }

    private void restoreDependencies(org.cytoscape.view.vizmap.VisualStyle visualStyle, VisualStyle vsModel) {
        Node nodeSection = vsModel.getNode();
        Edge edgeSection = vsModel.getEdge();
        Network networkSection = vsModel.getNetwork();
        HashSet<Dependency> dependencyStates = new HashSet<Dependency>();
        if (nodeSection != null) {
            dependencyStates.addAll(nodeSection.getDependency());
        }
        if (edgeSection != null) {
            dependencyStates.addAll(edgeSection.getDependency());
        }
        if (networkSection != null) {
            dependencyStates.addAll(networkSection.getDependency());
        }
        Set availableDependencies = visualStyle.getAllVisualPropertyDependencies();
        for (Dependency dep : dependencyStates) {
            String depName = dep.getName();
            Boolean enabled = dep.isValue();
            for (VisualPropertyDependency vsDependency : availableDependencies) {
                if (!vsDependency.getIdString().equalsIgnoreCase(depName)) continue;
                vsDependency.setDependency(enabled.booleanValue());
            }
        }
    }

    private void restoreDependencies(org.cytoscape.view.vizmap.VisualStyle visualStyle, TableColumnStyle vsModel) {
        Cell colSection = vsModel.getCell();
        HashSet<Dependency> dependencyStates = new HashSet<Dependency>();
        if (colSection != null) {
            dependencyStates.addAll(colSection.getDependency());
        }
        Set availableDependencies = visualStyle.getAllVisualPropertyDependencies();
        for (Dependency dep : dependencyStates) {
            String depName = dep.getName();
            Boolean enabled = dep.isValue();
            for (VisualPropertyDependency vsDependency : availableDependencies) {
                if (!vsDependency.getIdString().equalsIgnoreCase(depName)) continue;
                vsDependency.setDependency(enabled.booleanValue());
            }
        }
    }

    public <V> V parseValue(String sValue, org.cytoscape.view.model.VisualProperty<V> vp) {
        Object value = null;
        if (sValue != null && vp != null) {
            value = vp.parseSerializableString(sValue);
        }
        return (V)value;
    }

    private static AttributeType toAttributeType(Class<?> attrClass) {
        AttributeType attrType = AttributeType.STRING;
        if (attrClass == Boolean.class) {
            attrType = AttributeType.BOOLEAN;
        } else if (attrClass == Byte.class || attrClass == Short.class || attrClass == Integer.class) {
            attrType = AttributeType.INTEGER;
        } else if (attrClass == Long.class) {
            attrType = AttributeType.LONG;
        } else if (Number.class.isAssignableFrom(attrClass)) {
            attrType = AttributeType.FLOAT;
        }
        return attrType;
    }
}

