/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.io.util.RecentlyOpenedTracker;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecentlyOpenedTrackerImpl
implements RecentlyOpenedTracker {
    private static final String FILE_NAME = "tracker.recent.sessions";
    private static final int MAX_TRACK_COUNT = 100;
    private static final String MAX_FILES_PROP = "maxRecentlyOpenedFiles";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final LinkedList<URL> trackerURLs;
    private final File propDir;
    private final CyServiceRegistrar serviceRegistrar;

    public RecentlyOpenedTrackerImpl(CyServiceRegistrar serviceRegistrar) {
        this.propDir = ((CyApplicationConfiguration)serviceRegistrar.getService(CyApplicationConfiguration.class)).getConfigurationDirectoryLocation();
        this.trackerURLs = new LinkedList();
        this.serviceRegistrar = serviceRegistrar;
        File file = new File(this.propDir, FILE_NAME);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            logger.error("Problem creating empty file for Recently Opened File list", (Throwable)e);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));){
            String line;
            int max = this.getMaxRecentlyOpenedFiles();
            while ((line = reader.readLine()) != null && this.trackerURLs.size() < max) {
                String path = line.trim();
                if (path.isEmpty()) continue;
                URL url = new URL(path);
                this.trackerURLs.addLast(url);
            }
        }
        catch (Exception e) {
            logger.error("Problem reading Recently Opened File list", (Throwable)e);
        }
    }

    public synchronized List<URL> getRecentlyOpenedURLs() {
        return Collections.unmodifiableList(this.trackerURLs);
    }

    public synchronized void add(URL newURL) {
        this.trackerURLs.remove(newURL);
        if (this.trackerURLs.size() == this.getMaxRecentlyOpenedFiles()) {
            this.trackerURLs.removeLast();
        }
        this.trackerURLs.addFirst(newURL);
    }

    public void remove(URL url) {
        this.trackerURLs.remove(url);
    }

    public void clear() {
        this.trackerURLs.clear();
    }

    public void writeOut() throws FileNotFoundException {
        File file = new File(this.propDir, FILE_NAME);
        String ln = System.getProperty("line.separator");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            for (URL url : this.trackerURLs) {
                writer.write(url.toString() + ln);
            }
        }
        catch (Exception e) {
            logger.error("Problem writing Recently Opened File list", (Throwable)e);
        }
    }

    public synchronized URL getMostRecentlyOpenedURL() {
        if (this.trackerURLs.isEmpty()) {
            return null;
        }
        return this.trackerURLs.getFirst();
    }

    private int getMaxRecentlyOpenedFiles() {
        int max = 12;
        try {
            Properties props = (Properties)((CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)")).getProperties();
            String s = props.getProperty(MAX_FILES_PROP);
            if (s != null) {
                max = Integer.parseInt(s.trim());
            }
        }
        catch (Exception e) {
            logger.error("Cannot load property maxRecentlyOpenedFiles", (Throwable)e);
        }
        return Math.min(max, 100);
    }
}

