/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml.handler;

import java.util.Map;
import java.util.Set;
import org.cytoscape.io.internal.read.xgmml.ParseState;
import org.cytoscape.io.internal.read.xgmml.handler.AbstractHandler;
import org.cytoscape.io.internal.util.SUIDUpdater;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HandleGraphDone
extends AbstractHandler {
    @Override
    public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
        this.graphDone();
        if (this.manager.graphDoneCount != this.manager.graphCount) {
            return current;
        }
        Map<CyNetwork, Set<Long>> nodeMap = this.manager.getCache().getNodeLinks();
        for (Map.Entry<CyNetwork, Set<Long>> entry : nodeMap.entrySet()) {
            CyNetwork net = entry.getKey();
            Set<Long> ids = entry.getValue();
            if (net == null || ids == null || ids.isEmpty()) continue;
            if (net instanceof CySubNetwork) {
                CySubNetwork sn = (CySubNetwork)net;
                for (Long id : ids) {
                    CyNode n = this.manager.getCache().getNode(id);
                    if (n != null) {
                        sn.addNode(n);
                        continue;
                    }
                    logger.error("Cannot find XLink node with id \"" + id + "\".");
                }
                continue;
            }
            logger.error("Cannot add existing nodes \"" + ids.toArray() + "\" to a network which is not a CySubNetwork");
        }
        Map<CyNetwork, Set<Long>> edgeMap = this.manager.getCache().getEdgeLinks();
        for (Map.Entry<CyNetwork, Set<Long>> entry : edgeMap.entrySet()) {
            CyNetwork net = entry.getKey();
            Set<Long> ids = entry.getValue();
            if (net == null || ids == null || ids.isEmpty()) continue;
            if (net instanceof CySubNetwork) {
                CySubNetwork sn = (CySubNetwork)net;
                for (Long id : ids) {
                    CyEdge e = this.manager.getCache().getEdge(id);
                    if (e != null) {
                        sn.addEdge(e);
                        continue;
                    }
                    logger.error("Cannot find XLink edge with id \"" + id + "\".");
                }
                continue;
            }
            logger.error("Cannot add existing edges \"" + ids.toArray() + "\" to a network which is not a CySubNetwork");
        }
        this.manager.getCache().deleteUnresolvedNodes();
        this.resolveEquations();
        this.resolveNetworkPointers();
        this.updateSUIDAttributes();
        this.createGroups();
        return ParseState.NONE;
    }

    protected void graphDone() {
        Object netId;
        ++this.manager.graphDoneCount;
        if (!this.manager.getNetworkIDStack().isEmpty()) {
            this.manager.getNetworkIDStack().pop();
        }
        CyNetwork currentNet = null;
        Object object = netId = this.manager.getNetworkIDStack().isEmpty() ? null : this.manager.getNetworkIDStack().peek();
        if (netId != null) {
            currentNet = this.manager.getCache().getNetwork(netId);
        }
        this.manager.setCurrentElement((CyIdentifiable)currentNet);
    }

    private void resolveEquations() {
        if (!this.manager.isSessionFormat() || this.manager.getDocumentVersion() < 3.0) {
            this.manager.parseAllEquations();
        }
    }

    private void resolveNetworkPointers() {
        if (!this.manager.isSessionFormat()) {
            this.manager.getCache().createNetworkPointers();
        }
    }

    private void updateSUIDAttributes() {
        if (!this.manager.isSessionFormat()) {
            SUIDUpdater updater = this.manager.getSUIDUpdater();
            updater.addTables(this.manager.getCache().getNetworkTables());
            updater.updateSUIDColumns();
        }
    }

    private void createGroups() {
        if (!this.manager.isSessionFormat()) {
            this.manager.createGroups();
        }
    }
}

