/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml.handler;

import java.util.regex.Pattern;
import org.cytoscape.io.internal.read.xgmml.ObjectTypeMap;
import org.cytoscape.io.internal.read.xgmml.ParseState;
import org.cytoscape.io.internal.read.xgmml.handler.AbstractHandler;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HandleEdge
extends AbstractHandler {
    private static final String SPLIT_PATTERN = "[()]";
    private static final Pattern SPLIT = Pattern.compile("[()]");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ParseState handle(String tag, Attributes atts, ParseState current) throws SAXException {
        Object id = null;
        String href = atts.getValue("http://www.w3.org/1999/xlink", "href");
        if (href == null) {
            String[] parts;
            id = this.getId(atts);
            String label = this.getLabel(atts);
            Object sourceId = this.asLongOrString(atts.getValue("source"));
            Object targetId = this.asLongOrString(atts.getValue("target"));
            String isDirected = atts.getValue("cy:directed");
            String sourceAlias = null;
            String targetAlias = null;
            String interaction = "";
            if (label != null && (parts = SPLIT.split(label)).length == 3) {
                sourceAlias = parts[0];
                interaction = parts[1];
                targetAlias = parts[2];
            }
            boolean directed = isDirected == null ? this.manager.currentNetworkIsDirected : ObjectTypeMap.fromXGMMLBoolean(isDirected);
            CyNode sourceNode = null;
            CyNode targetNode = null;
            if (sourceId != null) {
                sourceNode = this.manager.getCache().getNode(sourceId);
            }
            if (targetId != null) {
                targetNode = this.manager.getCache().getNode(targetId);
            }
            if (sourceNode == null && sourceAlias != null) {
                sourceNode = this.manager.getCache().getNode(sourceAlias);
            }
            if (targetNode == null && targetAlias != null) {
                targetNode = this.manager.getCache().getNode(targetAlias);
            }
            if (label == null || label.isEmpty()) {
                label = String.format("%s (%s) %s", sourceId, directed ? "directed" : "undirected", targetId);
            }
            CyNetwork net = this.manager.getCurrentNetwork();
            CyEdge edge = null;
            if (sourceNode != null && targetNode != null) {
                boolean checkDuplicate = this.manager.getCache().hasNetworkPointers() && this.manager.getDocumentVersion() > 0.0 && this.manager.getDocumentVersion() < 3.0;
                CyEdge cyEdge = edge = checkDuplicate ? this.manager.getCache().getEdge(id) : null;
                if (edge == null) {
                    edge = this.manager.createEdge(sourceNode, targetNode, id, label, directed, net);
                } else if (net instanceof CySubNetwork && !net.containsEdge(edge)) {
                    ((CySubNetwork)net).addEdge(edge);
                }
            } else {
                edge = this.manager.createEdge(sourceId, targetId, id, label, directed, net);
            }
            if (edge == null) throw new SAXException("Cannot create edge from XGMML (id=" + id + " label=" + label + " source=" + sourceId + " target=" + targetId + "): source or target node not found");
            if (!this.manager.isSessionFormat() || this.manager.getDocumentVersion() < 3.0) {
                if (!net.containsEdge(edge)) {
                    net = this.manager.getRootNetwork();
                }
                if (net != null && net.containsEdge(edge)) {
                    CyRow row = net.getRow((CyIdentifiable)edge);
                    row.set("name", (Object)label);
                    row.set("interaction", (Object)interaction);
                }
                if (this.manager.getRootNetwork() != null && !this.manager.getRootNetwork().equals(net)) {
                    CyRow row = this.manager.getRootNetwork().getRow((CyIdentifiable)edge);
                    row.set("name", (Object)label);
                    row.set("interaction", (Object)interaction);
                }
            }
            this.manager.setCurrentElement((CyIdentifiable)edge);
            return current;
        } else {
            this.manager.addElementLink(href, CyEdge.class);
        }
        return current;
    }

    private final Object asLongOrString(String value) {
        if (value != null) {
            try {
                return Long.valueOf(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }
}

