/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.xgmml;

import java.io.InputStream;
import java.util.Map;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.internal.read.xgmml.GenericXGMMLReader;
import org.cytoscape.io.internal.read.xgmml.XGMMLParser;
import org.cytoscape.io.internal.read.xgmml.handler.ReadDataManager;
import org.cytoscape.io.internal.util.UnrecognizedVisualPropertyManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.TaskMonitor;

public class SessionXGMMLNetworkViewReader
extends GenericXGMMLReader {
    private boolean settingLockedVisualProperties;

    public SessionXGMMLNetworkViewReader(InputStream inputStream, ReadDataManager readDataMgr, XGMMLParser parser, UnrecognizedVisualPropertyManager unrecognizedVisualPropertyMgr, CyServiceRegistrar serviceRegistrar) {
        super(inputStream, readDataMgr, parser, unrecognizedVisualPropertyMgr, (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class), (CyNetworkFactory)serviceRegistrar.getService(CyNetworkFactory.class), null, (CyRootNetworkManager)serviceRegistrar.getService(CyRootNetworkManager.class), serviceRegistrar);
    }

    public String getVisualStyleName() {
        return this.readDataMgr.getVisualStyleName();
    }

    @Override
    protected void init(TaskMonitor tm) {
        super.init(tm);
        this.readDataMgr.setViewFormat(true);
    }

    @Override
    protected void setNetworkViewProperties(CyNetworkView netView) {
        Map<String, String> atts = this.readDataMgr.getViewGraphicsAttributes(this.readDataMgr.getNetworkId(), false);
        this.settingLockedVisualProperties = false;
        this.setVisualProperties(netView, (View<? extends CyIdentifiable>)netView, atts);
        atts = this.readDataMgr.getViewGraphicsAttributes(this.readDataMgr.getNetworkId(), true);
        this.settingLockedVisualProperties = true;
        this.setVisualProperties(netView, (View<? extends CyIdentifiable>)netView, atts);
        Object oldNetworkViewId = this.readDataMgr.getNetworkViewId();
        this.readDataMgr.getCache().cache(oldNetworkViewId, (CyIdentifiable)netView);
        if (oldNetworkViewId instanceof Long) {
            this.readDataMgr.getSUIDUpdater().addSUIDMapping((Long)oldNetworkViewId, netView.getSUID());
        }
    }

    @Override
    protected void setNodeViewProperties(CyNetworkView netView, View<CyNode> nodeView) {
        CyNode node = (CyNode)nodeView.getModel();
        Object oldId = this.readDataMgr.getCache().getOldId(node.getSUID());
        Map<String, String> atts = this.readDataMgr.getViewGraphicsAttributes(oldId, false);
        this.settingLockedVisualProperties = false;
        this.setVisualProperties(netView, nodeView, atts);
        atts = this.readDataMgr.getViewGraphicsAttributes(oldId, true);
        this.settingLockedVisualProperties = true;
        this.setVisualProperties(netView, nodeView, atts);
    }

    @Override
    protected void setEdgeViewProperties(CyNetworkView netView, View<CyEdge> edgeView) {
        CyEdge edge = (CyEdge)edgeView.getModel();
        Object oldId = this.readDataMgr.getCache().getOldId(edge.getSUID());
        Map<String, String> atts = this.readDataMgr.getViewGraphicsAttributes(oldId, false);
        this.settingLockedVisualProperties = false;
        this.setVisualProperties(netView, edgeView, atts);
        atts = this.readDataMgr.getViewGraphicsAttributes(oldId, true);
        this.settingLockedVisualProperties = true;
        this.setVisualProperties(netView, edgeView, atts);
    }

    @Override
    protected boolean isLockedVisualProperty(CyIdentifiable element, String attName) {
        return this.settingLockedVisualProperties;
    }
}

