/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.datatable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Set;
import org.cytoscape.io.BasicCyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.util.StreamUtil;

public class SessionTableFileFilter
extends BasicCyFileFilter {
    public SessionTableFileFilter(Set<String> extensions, Set<String> contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
    }

    public SessionTableFileFilter(String[] extensions, String[] contentTypes, String description, DataCategory category, StreamUtil streamUtil) {
        super(extensions, contentTypes, description, category, streamUtil);
    }

    public boolean accepts(InputStream stream, DataCategory category) {
        if (category != DataCategory.TABLE) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8").newDecoder()));
        try {
            String line = reader.readLine().trim();
            if (line.startsWith("<")) {
                return false;
            }
            return line.contains(",");
        }
        catch (IOException e) {
            return false;
        }
    }
}

