/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.datatable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.cytoscape.io.read.CyTableReader;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyAttributesReader
extends AbstractTask
implements CyTableReader {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final byte TYPE_BOOLEAN = 1;
    private static final byte TYPE_FLOATING_POINT = 2;
    private static final byte TYPE_INTEGER = 3;
    private static final byte TYPE_STRING = 4;
    private static final String ENCODING_SCHEME = "UTF-8";
    private static final String DECODE_PROPERTY = "cytoscape.decode.attributes";
    private boolean badDecode;
    private int lineNum = 0;
    private boolean doDecoding = Boolean.valueOf(System.getProperty("cytoscape.decode.attributes", "true"));
    private InputStream inputStream;
    private CyTable[] cyTables;
    private static int nextTableNumber = 1;
    private final CyServiceRegistrar serviceRegistrar;

    public CyAttributesReader(InputStream inputStream, CyServiceRegistrar serviceRegistrar) {
        this.inputStream = inputStream;
        this.serviceRegistrar = serviceRegistrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor tm) throws IOException {
        tm.setProgress(0.0);
        CyTableFactory tableFactory = (CyTableFactory)this.serviceRegistrar.getService(CyTableFactory.class);
        CyTable table = tableFactory.createTable("Table " + Integer.toString(nextTableNumber++), "name", String.class, true, true);
        this.cyTables = new CyTable[]{table};
        tm.setProgress(0.1);
        try {
            this.loadAttributesInternal(table);
            tm.setProgress(0.3);
        }
        finally {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        tm.setProgress(1.0);
    }

    private void loadAttributesInternal(CyTable table) throws IOException {
        InputStreamReader reader1 = new InputStreamReader(this.inputStream, Charset.forName(ENCODING_SCHEME).newDecoder());
        this.badDecode = false;
        boolean guessedAttrType = false;
        try {
            String attributeName;
            BufferedReader reader = new BufferedReader(reader1);
            int type = -1;
            String firstLine = reader.readLine();
            ++this.lineNum;
            if (firstLine == null) {
                return;
            }
            String searchStr = "class=";
            int inx = firstLine.indexOf("class=");
            if (inx < 0) {
                attributeName = firstLine.trim();
            } else {
                attributeName = firstLine.substring(0, inx - 1).trim();
                String foo = firstLine.substring(inx);
                StringTokenizer tokens = new StringTokenizer(foo);
                String className = (foo = tokens.nextToken()).substring("class=".length()).trim();
                if (className.endsWith(")")) {
                    className = className.substring(0, className.length() - 1);
                }
                if (className.equalsIgnoreCase(String.class.toString()) || className.equalsIgnoreCase("String")) {
                    type = 4;
                } else if (className.equalsIgnoreCase(Boolean.class.toString()) || className.equalsIgnoreCase("Boolean")) {
                    type = 1;
                } else if (className.equalsIgnoreCase(Integer.class.toString()) || className.equalsIgnoreCase("Integer")) {
                    type = 3;
                } else if (className.equalsIgnoreCase(Double.class.toString()) || className.equalsIgnoreCase("Double") || className.equalsIgnoreCase(Float.class.toString()) || className.equalsIgnoreCase("Float")) {
                    type = 2;
                }
                logger.debug("New Column Loaded.  Data Type = " + attributeName + ": " + (byte)type);
            }
            if (attributeName.indexOf("(") >= 0) {
                attributeName = attributeName.substring(0, attributeName.indexOf("(")).trim();
            }
            boolean firstLineDefined = true;
            boolean list = false;
            while (true) {
                String line = reader.readLine();
                ++this.lineNum;
                if (line == null) break;
                if ("".equals(line.trim())) continue;
                int inx2 = line.indexOf(61);
                String key = line.substring(0, inx2).trim();
                String val = line.substring(inx2 + 1).trim();
                key = this.decodeString(key);
                if (firstLineDefined && val.startsWith("(")) {
                    list = true;
                }
                if (list) {
                    val = val.substring(1).trim();
                    val = val.substring(0, val.length() - 1).trim();
                    String[] elms = val.split("::");
                    ArrayList<Object> elmsBuff = new ArrayList<Object>();
                    for (String vs : elms) {
                        vs = this.decodeString(vs);
                        vs = CyAttributesReader.decodeSlashEscapes(vs);
                        elmsBuff.add(vs);
                    }
                    if (firstLineDefined) {
                        if (type < 0) {
                            guessedAttrType = true;
                            try {
                                new Integer((String)elmsBuff.get(0));
                                type = 3;
                            }
                            catch (Exception exception) {
                                try {
                                    new Double((String)elmsBuff.get(0));
                                    type = 2;
                                }
                                catch (Exception exception2) {
                                    type = 4;
                                }
                            }
                        }
                        firstLineDefined = false;
                    }
                    for (int i = 0; i < elmsBuff.size(); ++i) {
                        if (type == 3) {
                            elmsBuff.set(i, new Integer((String)elmsBuff.get(i)));
                            continue;
                        }
                        if (type == 1) {
                            elmsBuff.set(i, new Boolean((String)elmsBuff.get(i)));
                            continue;
                        }
                        if (type != 2) continue;
                        elmsBuff.set(i, new Double((String)elmsBuff.get(i)));
                    }
                    this.setListAttribute(table, (byte)type, key, attributeName, elmsBuff);
                    continue;
                }
                val = this.decodeString(val);
                val = CyAttributesReader.decodeSlashEscapes(val);
                if (firstLineDefined) {
                    if (type < 0) {
                        guessedAttrType = true;
                        try {
                            new Integer(val);
                            type = 3;
                        }
                        catch (Exception exception) {
                            try {
                                new Double(val);
                                type = 2;
                            }
                            catch (Exception exception3) {
                                type = 4;
                            }
                        }
                    }
                    firstLineDefined = false;
                }
                this.setAttributeForType(table, (byte)type, key, attributeName, val);
            }
        }
        catch (Exception e) {
            String message = guessedAttrType ? "failed parsing data table file at line: " + this.lineNum + " with exception: " + e.getMessage() + " This is most likely due to a missing attribute type on the first line.\nColumn type should be one of the following: (class=String), (class=Boolean), (class=Integer), or (class=Double). (\"Double\" stands for a floating point a.k.a. \"decimal\" number.) This should be added to end of the first line." : "failed parsing data table file at line: " + this.lineNum + " with exception: " + e.getMessage();
            logger.warn(message, (Throwable)e);
            throw new IOException(message);
        }
    }

    private void setAttributeForType(CyTable tbl, byte type, String key, String attributeName, String val) {
        if (tbl.getColumn(attributeName) == null) {
            if (type == 3) {
                tbl.createColumn(attributeName, Integer.class, false);
            } else if (type == 1) {
                tbl.createColumn(attributeName, Boolean.class, false);
            } else if (type == 2) {
                tbl.createColumn(attributeName, Double.class, false);
            } else {
                tbl.createColumn(attributeName, String.class, false);
            }
        }
        CyRow row = tbl.getRow((Object)key);
        if (type == 3) {
            row.set(attributeName, (Object)new Integer(val));
        } else if (type == 1) {
            row.set(attributeName, (Object)new Boolean(val));
        } else if (type == 2) {
            row.set(attributeName, (Object)new Double(val));
        } else {
            row.set(attributeName, (Object)new String(val));
        }
    }

    private void setListAttribute(CyTable tbl, Byte type, String key, String attributeName, List<?> elmsBuff) {
        if (tbl.getColumn(attributeName) == null) {
            if (type == 3) {
                tbl.createListColumn(attributeName, Integer.class, false);
            } else if (type == 1) {
                tbl.createListColumn(attributeName, Boolean.class, false);
            } else if (type == 2) {
                tbl.createListColumn(attributeName, Double.class, false);
            } else {
                tbl.createListColumn(attributeName, String.class, false);
            }
        }
        CyRow row = tbl.getRow((Object)key);
        row.set(attributeName, elmsBuff);
    }

    private String decodeString(String in) throws IOException {
        block3: {
            if (this.doDecoding) {
                try {
                    in = URLDecoder.decode(in, ENCODING_SCHEME);
                }
                catch (IllegalArgumentException iae) {
                    if (this.badDecode) break block3;
                    this.badDecode = true;
                }
            }
        }
        return in;
    }

    private static String decodeSlashEscapes(String in) {
        StringBuilder elmBuff = new StringBuilder();
        for (int inx2 = 0; inx2 < in.length(); ++inx2) {
            char ch = in.charAt(inx2);
            if (ch == '\\') {
                char ch2;
                if (inx2 + 1 >= in.length()) continue;
                if ((ch2 = in.charAt(++inx2)) == 'n') {
                    elmBuff.append('\n');
                    continue;
                }
                if (ch2 == 't') {
                    elmBuff.append('\t');
                    continue;
                }
                if (ch2 == 'b') {
                    elmBuff.append('\b');
                    continue;
                }
                if (ch2 == 'r') {
                    elmBuff.append('\r');
                    continue;
                }
                if (ch2 == 'f') {
                    elmBuff.append('\f');
                    continue;
                }
                elmBuff.append(ch2);
                continue;
            }
            elmBuff.append(ch);
        }
        return elmBuff.toString();
    }

    public boolean isDoDecoding() {
        return this.doDecoding;
    }

    public void setDoDecoding(boolean doDec) {
        this.doDecoding = doDec;
    }

    public CyTable[] getTables() {
        return this.cyTables;
    }
}

