/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkSupportedInputStream
extends InputStream {
    private final InputStream is;

    public MarkSupportedInputStream(InputStream eis) throws IOException {
        if (eis.markSupported()) {
            this.is = eis;
        } else {
            ByteArrayOutputStream copy = new ByteArrayOutputStream();
            int chunk = 0;
            byte[] data = new byte[1024];
            while (-1 != (chunk = eis.read(data))) {
                copy.write(data, 0, chunk);
            }
            this.is = new ByteArrayInputStream(copy.toByteArray());
        }
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.is.read(b, off, len);
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }
}

