/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.internal.read.CopyInputStream;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.Task;

public class GenericReaderManager<T extends InputStreamTaskFactory, R extends Task> {
    private static final Logger userLogger = Logger.getLogger((String)"org.cytoscape.application.userlog");
    private static final Logger logger = Logger.getLogger(GenericReaderManager.class);
    private static final String DEFAULT_READER_FACTORY_CLASS = "org.cytoscape.tableimport.internal.ImportNetworkTableReaderFactory";
    protected final DataCategory category;
    protected final StreamUtil streamUtil;
    protected final Set<T> factories;

    public GenericReaderManager(DataCategory category, StreamUtil streamUtil) {
        this.category = category;
        this.streamUtil = streamUtil;
        this.factories = new CopyOnWriteArraySet<T>();
    }

    public void addInputStreamTaskFactory(T factory, Map props) {
        if (factory == null) {
            logger.warn((Object)"Specified factory is null.");
        } else if (factory.getFileFilter().getDataCategory() == this.category) {
            this.factories.add(factory);
        }
    }

    public void removeInputStreamTaskFactory(T factory, Map props) {
        this.factories.remove(factory);
    }

    public R getReader(URI uri, String inputName) {
        if (uri == null) {
            throw new NullPointerException("Data source URI is null");
        }
        InputStreamTaskFactory defaultFactory = null;
        ArrayList<InputStreamTaskFactory> factoryList = new ArrayList<InputStreamTaskFactory>();
        HashMap<String, InputStreamTaskFactory> factoryTable = new HashMap<String, InputStreamTaskFactory>();
        for (InputStreamTaskFactory factory : this.factories) {
            CyFileFilter cff = factory.getFileFilter();
            if (!cff.accepts(uri, this.category)) continue;
            logger.info((Object)("Filter returns Accepted.  Need to check priority: " + factory));
            if (factory.getClass().toString().contains(DEFAULT_READER_FACTORY_CLASS)) {
                defaultFactory = factory;
                continue;
            }
            factoryList.add(factory);
            for (String extension : cff.getExtensions()) {
                factoryTable.put(extension, factory);
            }
        }
        InputStreamTaskFactory chosenFactory = null;
        if (factoryTable.isEmpty() && defaultFactory == null) {
            userLogger.warn((Object)("No reader found for uri: " + uri.toString()));
            throw new IllegalStateException("Don't know how to read " + uri.toString());
        }
        if (factoryList.size() == 1) {
            chosenFactory = (InputStreamTaskFactory)factoryList.get(0);
        } else if (factoryList.isEmpty() && defaultFactory != null) {
            chosenFactory = defaultFactory;
        } else {
            String extension = FilenameUtils.getExtension((String)uri.toString());
            if (factoryTable.containsKey(extension)) {
                chosenFactory = (InputStreamTaskFactory)factoryTable.get(extension);
            } else if (factoryTable.containsKey("")) {
                chosenFactory = (InputStreamTaskFactory)factoryTable.get("");
            } else {
                userLogger.warn((Object)("Can't figure out how to read: " + uri.toString() + " from extension"));
                throw new IllegalStateException("Can't figure out how to read " + uri.toString() + " from extension");
            }
        }
        try {
            logger.info((Object)("Successfully found compatible ReaderFactory " + chosenFactory));
            InputStream stream = this.streamUtil.getInputStream(uri.toURL());
            return (R)chosenFactory.createTaskIterator(stream, inputName).next();
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("File '" + inputName + "' not found:", e);
        }
        catch (IOException e) {
            userLogger.warn((Object)("Error opening stream to URI: " + uri.toString()), (Throwable)e);
            throw new IllegalStateException("Could not open stream for reader.", e);
        }
    }

    public R getReader(InputStream stream, String inputName) {
        try {
            String lowerName;
            if (!stream.markSupported()) {
                stream = new BufferedInputStream(stream);
                stream.mark(1025);
            }
            int kb = 1;
            String string = lowerName = inputName != null ? inputName.toLowerCase() : "";
            if (lowerName.endsWith(".xgmml")) {
                kb += 2 * lowerName.length() / 1024;
            }
            for (InputStreamTaskFactory factory : this.factories) {
                CyFileFilter cff = factory.getFileFilter();
                if (!cff.accepts(CopyInputStream.copyKBytes(stream, kb), this.category)) continue;
                return (R)factory.createTaskIterator(stream, inputName).next();
            }
        }
        catch (IOException ioe) {
            userLogger.warn((Object)"Error setting input stream", (Throwable)ioe);
        }
        userLogger.warn((Object)("No reader found for input stream: " + inputName));
        return null;
    }
}

