/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.math.xform;

import org.cytoscape.math.xform.Matrix4x4;
import org.cytoscape.math.xform.Point3D;
import org.cytoscape.math.xform.Transformation3D;

public abstract class AffineTransform3D
implements Transformation3D {
    final Matrix4x4 m_matrix;

    AffineTransform3D(Matrix4x4 matrix) {
        this.m_matrix = matrix;
    }

    @Override
    public Point3D transform(Point3D pt3D) {
        double[] arr3D = new double[]{pt3D.x, pt3D.y, pt3D.z};
        this.transformArr(arr3D);
        return new Point3D(arr3D[0], arr3D[1], arr3D[2]);
    }

    public void transformArr(double[] arr3D) {
        this.m_matrix.transform(arr3D);
    }

    public AffineTransform3D concatenatePre(AffineTransform3D xform) {
        return new AffineTransform3D(this.m_matrix.multiply(xform.m_matrix)){};
    }

    public AffineTransform3D concatenatePost(AffineTransform3D xform) {
        return xform.concatenatePre(this);
    }
}

