/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.internal.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.Palette;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.internal.color.AbstractPalette;
import org.cytoscape.util.internal.color.ColorBrewer;

public class ColorBrewerPaletteProvider
implements PaletteProvider {
    Map<PaletteType, Map<String, ColorBrewer>> paletteMap = new HashMap<PaletteType, Map<String, ColorBrewer>>();

    public ColorBrewerPaletteProvider() {
        this.paletteMap.put((PaletteType)BrewerType.SEQUENTIAL, this.getBrewerPalettes(ColorBrewer.getSequentialColorPalettes(false)));
        this.paletteMap.put((PaletteType)BrewerType.QUALITATIVE, this.getBrewerPalettes(ColorBrewer.getQualitativeColorPalettes(false)));
        this.paletteMap.put((PaletteType)BrewerType.DIVERGING, this.getBrewerPalettes(ColorBrewer.getDivergingColorPalettes(false)));
    }

    public String getProviderName() {
        return "ColorBrewer";
    }

    public List<PaletteType> getPaletteTypes() {
        return Arrays.asList(BrewerType.SEQUENTIAL, BrewerType.QUALITATIVE, BrewerType.DIVERGING);
    }

    public List<String> listPaletteNames(PaletteType type, boolean colorBlindSafe) {
        Map<Object, Object> palettes;
        if (type.equals(BrewerType.ANY)) {
            palettes = new HashMap();
            for (Map<String, ColorBrewer> palette : this.paletteMap.values()) {
                for (String name : palette.keySet()) {
                    palettes.put(name, (Object)palette.get(name));
                }
            }
        } else {
            palettes = this.paletteMap.get(type);
        }
        if (colorBlindSafe) {
            ArrayList<String> names = new ArrayList<String>();
            for (String string : palettes.keySet()) {
                if (!((ColorBrewer)((Object)palettes.get(string))).isColorBlindSave()) continue;
                names.add(string);
            }
            return names;
        }
        return new ArrayList<Object>(palettes.keySet());
    }

    public List<Object> listPaletteIdentifiers(PaletteType type, boolean colorBlindSafe) {
        Map<Object, Object> palettes;
        if (type.equals(BrewerType.ANY)) {
            palettes = new HashMap();
            for (Map<String, ColorBrewer> palette : this.paletteMap.values()) {
                for (String name : palette.keySet()) {
                    palettes.put(name, (Object)palette.get(name));
                }
            }
        } else {
            palettes = this.paletteMap.get(type);
        }
        if (colorBlindSafe) {
            ArrayList<Object> safePalettes = new ArrayList<Object>();
            for (String string : palettes.keySet()) {
                if (!((ColorBrewer)((Object)palettes.get(string))).isColorBlindSave()) continue;
                safePalettes.add(palettes.get(string));
            }
            return safePalettes;
        }
        return new ArrayList<Object>(palettes.values());
    }

    public Palette getPalette(String paletteName) {
        return this.getPalette(paletteName, 8);
    }

    public Palette getPalette(String paletteName, int size) {
        for (PaletteType type : this.paletteMap.keySet()) {
            Map<String, ColorBrewer> palettes = this.paletteMap.get(type);
            for (String name : palettes.keySet()) {
                if (!name.equalsIgnoreCase(paletteName)) continue;
                return new BrewerPalette(this, palettes.get(name), size, type);
            }
        }
        return null;
    }

    public Palette getPalette(Object paletteIdentifier) {
        return this.getPalette(paletteIdentifier, 8);
    }

    public Palette getPalette(Object paletteIdentifier, int size) {
        for (PaletteType type : this.paletteMap.keySet()) {
            Map<String, ColorBrewer> palettes = this.paletteMap.get(type);
            for (ColorBrewer cb : palettes.values()) {
                if (!paletteIdentifier.equals((Object)cb)) continue;
                return new BrewerPalette(this, cb, size, type);
            }
        }
        return null;
    }

    private Map<String, ColorBrewer> getBrewerPalettes(ColorBrewer[] palettes) {
        HashMap<String, ColorBrewer> paletteMap = new HashMap<String, ColorBrewer>();
        for (ColorBrewer cb : palettes) {
            paletteMap.put(cb.getPaletteDescription(), cb);
        }
        return paletteMap;
    }

    class BrewerPalette
    extends AbstractPalette {
        ColorBrewer palette;
        PaletteProvider provider;

        public BrewerPalette(PaletteProvider provider, ColorBrewer cbPalette, int size, PaletteType type) {
            super(provider, cbPalette.getPaletteDescription(), size, type, cbPalette.isColorBlindSave());
            this.palette = cbPalette;
            this.size = size;
            this.type = type;
            this.provider = provider;
        }

        @Override
        public String getName() {
            if (this.reversed) {
                return this.palette.getPaletteDescription() + " (R)";
            }
            return this.palette.getPaletteDescription();
        }

        @Override
        public Object getIdentifier() {
            return this.palette;
        }

        @Override
        public boolean isColorBlindSafe() {
            return this.palette.isColorBlindSave();
        }

        @Override
        public boolean isReversable() {
            return true;
        }

        @Override
        public PaletteType getType() {
            return this.type;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Color[] getColors(int nColors) {
            if (this.reversed) {
                return this.reverseColors(this.palette.getColorPalette(nColors));
            }
            return this.palette.getColorPalette(nColors);
        }

        @Override
        public Color[] getColors() {
            return this.getColors(this.size);
        }

        public String toString() {
            return "ColorBrewer " + this.getName();
        }

        @Override
        public PaletteProvider getPaletteProvider() {
            return this.provider;
        }
    }
}

