/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.internal.color;

import java.awt.Color;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.PaletteProvider;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.internal.color.AbstractPalette;

public class AbstractDivergingPalette
extends AbstractPalette {
    protected Color[] colors;

    AbstractDivergingPalette(PaletteProvider provider, String name, Color[] colors, boolean cbs) {
        super(provider, name, colors.length, (PaletteType)BrewerType.DIVERGING, cbs);
        this.colors = colors;
    }

    @Override
    public Color[] getColors() {
        if (this.reversed) {
            return this.reverseColors(this.colors);
        }
        return this.colors;
    }

    @Override
    public Color[] getColors(int nColors) {
        if (nColors == this.colors.length) {
            this.getColors();
        }
        if (this.reversed) {
            return this.reverseColors(this.interpolatedColors(nColors));
        }
        return this.interpolatedColors(nColors);
    }

    public String toString() {
        return super.getName();
    }

    @Override
    public boolean isReversable() {
        return true;
    }

    private Color[] interpolatedColors(int colorCount) {
        Color[] newColors = new Color[colorCount];
        int maxIndex = this.colors.length - 1;
        float scale = (float)maxIndex / (float)(colorCount - 1);
        for (int i = 0; i < colorCount; ++i) {
            float value = scale * (float)i;
            int index = (int)Math.floor(value);
            Color c1 = this.colors[index];
            float remainder = 0.0f;
            Color c2 = null;
            if (index + 1 < this.colors.length) {
                c2 = this.colors[index + 1];
                remainder = value - (float)index;
            } else {
                c2 = this.colors[index];
            }
            int red = Math.round((1.0f - remainder) * (float)c1.getRed() + remainder * (float)c2.getRed());
            int green = Math.round((1.0f - remainder) * (float)c1.getGreen() + remainder * (float)c2.getGreen());
            int blue = Math.round((1.0f - remainder) * (float)c1.getBlue() + remainder * (float)c2.getBlue());
            newColors[i] = new Color(red, green, blue);
        }
        return newColors;
    }
}

