/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.functions;

import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;

public class GetTableCell
extends AbstractFunction {
    protected final CyServiceRegistrar registrar;
    protected final Class<?> clazz;

    public GetTableCell(CyServiceRegistrar serviceRegistrar, Class<?> clazz) {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.INT, "SUID", "The SUID identifying the node or edge."), new ArgDescriptor(ArgType.STRING, "Column", "The name of the column to get.")});
        this.registrar = serviceRegistrar;
        this.clazz = clazz;
    }

    public String getName() {
        return this.clazz.getSimpleName().toUpperCase() + "TABLECELL";
    }

    public String getFunctionSummary() {
        return "Returns the value in the column for the specified SUID";
    }

    public Class<?> getReturnType() {
        return this.clazz;
    }

    public Object evaluateFunction(Object[] args) {
        Object result;
        Long suid = FunctionUtil.getArgAsLong((Object)args[0]);
        String column = FunctionUtil.getArgAsString((Object)args[1]);
        CyNetwork currentNetwork = ((CyApplicationManager)this.registrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        if (currentNetwork != null && (result = this.findIdentifiableInNetwork(currentNetwork, suid, column)) != null) {
            return result;
        }
        Set allNetworks = ((CyNetworkManager)this.registrar.getService(CyNetworkManager.class)).getNetworkSet();
        for (CyNetwork network : allNetworks) {
            Object result2;
            if (network == currentNetwork || (result2 = this.findIdentifiableInNetwork(network, suid, column)) == null) continue;
            return result2;
        }
        throw new IllegalArgumentException("\"" + suid + "\" is not a valid identifier.");
    }

    private Object findIdentifiableInNetwork(CyNetwork network, Long suid, String column) {
        CyNode node = network.getNode(suid.longValue());
        if (node != null) {
            return this.getColumn((CyIdentifiable)node, network, column);
        }
        CyEdge edge = network.getEdge(suid.longValue());
        if (edge != null) {
            return this.getColumn((CyIdentifiable)edge, network, column);
        }
        if (network.getSUID().equals(suid)) {
            return this.getColumn((CyIdentifiable)network, network, column);
        }
        return null;
    }

    private Object getColumn(CyIdentifiable id, CyNetwork network, String column) {
        CyRow row = network.getRow(id);
        return row.get(column, this.clazz);
    }
}

