/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.enfin.mi.cluster.cache;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shiftone.cache.adaptor.CacheMap;
import org.shiftone.cache.adaptor.EHCacheCache;
import uk.ac.ebi.enfin.mi.cluster.EncoreInteraction;
import uk.ac.ebi.enfin.mi.cluster.cache.CacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EHCacheManager
implements CacheManager {
    private static final Log log = LogFactory.getLog(EHCacheManager.class);
    private static final String INTERACTION_CACHE_NAME = "interactions.eternal-ondisk";
    private static final String INTERACTORS_CACHE_NAME = "interactors.eternal-ondisk";
    private static final String INTERACTOR_SYNONYMS_CACHE_NAME = "interactor-synonyms.eternal-ondisk";
    public static final String EHCACHE_CONFIG_FILE = "/ehcache-config.xml";
    private static final String DEFAULT_CACHE_LOCATION = System.getProperty("java.io.tmpdir") + "/micluster";
    private net.sf.ehcache.CacheManager ehcacheManager;
    private File cacheStorage = new File(DEFAULT_CACHE_LOCATION);
    private boolean resetCache = true;
    private Map<String, Boolean> cache2resetStatus = new HashMap<String, Boolean>();
    private boolean isCacheSynchronized = false;

    @Override
    public File getCacheStorage() {
        return this.cacheStorage;
    }

    @Override
    public void setCacheStorage(File cacheStorage) {
        if (this.ehcacheManager != null) {
            throw new IllegalStateException("You can only set the storage location of your caches before building them");
        }
        this.cacheStorage = cacheStorage;
    }

    @Override
    public synchronized boolean isResetCache() {
        return this.resetCache;
    }

    @Override
    public synchronized void setResetCache(boolean resetCache) {
        this.resetCache = resetCache;
        if (resetCache) {
            this.cache2resetStatus.clear();
        }
    }

    @Override
    public synchronized boolean isCacheSynchronized() {
        return this.isCacheSynchronized;
    }

    @Override
    public synchronized void setCacheSynchronized(boolean cacheSynchronized) {
        this.isCacheSynchronized = cacheSynchronized;
    }

    public synchronized Map<Integer, EncoreInteraction> getInteractionCache() {
        return this.buildCache(INTERACTION_CACHE_NAME);
    }

    @Override
    public synchronized Map<String, List<Integer>> getInteractorCache() {
        return this.buildCache(INTERACTORS_CACHE_NAME);
    }

    @Override
    public Map<String, String> getSynonymCache() {
        return this.buildCache(INTERACTOR_SYNONYMS_CACHE_NAME);
    }

    private synchronized Map buildCache(String cacheName) {
        Cache cache;
        if (this.ehcacheManager == null) {
            log.info((Object)"Setting System's property: net.sf.ehcache.enableShutdownHook=true");
            System.setProperty("net.sf.ehcache.enableShutdownHook", "true");
            URL url = this.getClass().getResource(EHCACHE_CONFIG_FILE);
            if (url == null) {
                throw new IllegalArgumentException("You must give a non null ehcache configuration url:/ehcache-config.xml");
            }
            Configuration configuration = ConfigurationFactory.parseConfiguration((URL)url);
            configuration.getDiskStoreConfiguration().setPath(this.cacheStorage.getAbsolutePath());
            this.ehcacheManager = new net.sf.ehcache.CacheManager(configuration);
        }
        if ((cache = this.ehcacheManager.getCache(cacheName)) == null) {
            throw new IllegalStateException("Could not find cache by name: '" + cacheName + "'");
        }
        Object map = new CacheMap((org.shiftone.cache.Cache)new EHCacheCache(cache));
        if (this.isCacheSynchronized) {
            map = Collections.synchronizedMap(map);
        }
        if (this.resetCache) {
            boolean hasReset;
            if (!this.cache2resetStatus.containsKey(cacheName)) {
                this.cache2resetStatus.put(cacheName, Boolean.FALSE);
            }
            if (!(hasReset = this.cache2resetStatus.get(cacheName).booleanValue())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Clearing up cache '" + cacheName + "' that contained " + map.size() + " elements."));
                }
                map.clear();
                this.cache2resetStatus.put(cacheName, Boolean.TRUE);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Map('" + cacheName + "') contains " + map.size() + " entr" + (map.size() == 1 ? "y" : "ies")));
        }
        return map;
    }

    @Override
    public void shutdown() {
        if (this.ehcacheManager != null && Status.STATUS_ALIVE.equals(this.ehcacheManager.getStatus())) {
            this.shutdownIfActive(this.ehcacheManager.getCache(INTERACTION_CACHE_NAME));
            this.shutdownIfActive(this.ehcacheManager.getCache(INTERACTORS_CACHE_NAME));
            this.shutdownIfActive(this.ehcacheManager.getCache(INTERACTOR_SYNONYMS_CACHE_NAME));
            log.info((Object)"Shutting down EHCache EHCacheManager...");
            this.ehcacheManager.shutdown();
        }
    }

    private void shutdownIfActive(Cache cache) {
        if (Status.STATUS_ALIVE.equals(cache.getStatus())) {
            System.out.println("Attempting to dispose of: " + cache.getName() + "...");
            cache.dispose();
        } else {
            System.out.println("Cache('" + cache.getName() + "') was not alive. Skipping dispose()...");
        }
    }
}

