/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.enfin.mi.cluster;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hupo.psi.mi.psicquic.registry.ServiceType;
import org.hupo.psi.mi.psicquic.registry.client.PsicquicRegistryClientException;
import org.hupo.psi.mi.psicquic.registry.client.registry.DefaultPsicquicRegistryClient;
import psidev.psi.mi.tab.PsimiTabWriter;
import psidev.psi.mi.tab.model.BinaryInteraction;
import uk.ac.ebi.enfin.mi.cluster.AbstractInteractionCluster;
import uk.ac.ebi.enfin.mi.cluster.ClusterServiceException;
import uk.ac.ebi.enfin.mi.cluster.Encore2Binary;
import uk.ac.ebi.enfin.mi.cluster.EncoreInteraction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class InteractionClusterAdv
extends AbstractInteractionCluster<EncoreInteraction> {
    private static Logger logger = Logger.getLogger(InteractionClusterAdv.class);
    protected List<String> querySources = new ArrayList<String>();
    protected List<String> queryAccs = new ArrayList<String>();

    public InteractionClusterAdv(List<BinaryInteraction> binaryInteractionList, String mappingIdDbNames) {
        super(binaryInteractionList, mappingIdDbNames);
    }

    public InteractionClusterAdv(List<BinaryInteraction> binaryInteractionList) {
        super(binaryInteractionList);
    }

    public InteractionClusterAdv(InputStream is, boolean hasHeader) throws ClusterServiceException {
        this(new InputStreamReader(is), hasHeader);
    }

    public InteractionClusterAdv(Reader r, boolean hasHeader) throws ClusterServiceException {
        super(r, hasHeader);
    }

    public InteractionClusterAdv(Iterator<BinaryInteraction> iterator) throws ClusterServiceException {
        super(iterator);
    }

    public InteractionClusterAdv(List<String> queryAcc, List<String> querySource, int queryStart, int queryRange) {
        super(queryStart, queryRange);
        if (queryAcc != null) {
            this.queryAccs = queryAcc;
        }
        if (querySource != null) {
            this.querySources = querySource;
        }
    }

    public InteractionClusterAdv(List<String> queryAcc, List<String> querySource, int queryStart, int queryRange, String mappingIdDbNames) {
        super(queryStart, queryRange, mappingIdDbNames);
        if (queryAcc != null) {
            this.queryAccs = queryAcc;
        }
        if (querySource != null) {
            this.querySources = querySource;
        }
    }

    public InteractionClusterAdv() {
        super(0, 200);
    }

    public InteractionClusterAdv(String mappingIdDbNames) {
        super(mappingIdDbNames);
    }

    public InteractionClusterAdv(List<String> queryAcc, List<String> querySource, String mappingIdDbNames) {
        super(mappingIdDbNames);
        if (queryAcc != null) {
            this.queryAccs = queryAcc;
        }
        if (querySource != null) {
            this.querySources = querySource;
        }
    }

    public InteractionClusterAdv(List<String> queryAcc, List<String> querySource) {
        super(0, 200);
        if (queryAcc != null) {
            this.queryAccs = queryAcc;
        }
        if (querySource != null) {
            this.querySources = querySource;
        }
    }

    @Override
    protected void setMappingForPsicquic() {
        if (this.queryAccs.size() > 0 && this.querySources.size() > 0) {
            for (String queryAcc : this.queryAccs) {
                for (String querySource : this.querySources) {
                    try {
                        super.setMappingForPsicquic(queryAcc, querySource);
                    }
                    catch (IOException e) {
                        logger.error((Object)("Problem setting mapping for PSICQUIC for query source: " + querySource), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    protected EncoreInteraction convertEncoreInteractionFrom(BinaryInteraction interaction, String[] idDbNameList) {
        this.binary2Encore.setIdDbNameList(idDbNameList);
        return this.binary2Encore.getEncoreInteraction(interaction);
    }

    @Override
    protected void processMethodAndType(EncoreInteraction encoreInteraction, EncoreInteraction mappingEncoreInteraction) {
        mappingEncoreInteraction.addMethodToPubmed(encoreInteraction.getMethodToPubmed());
        mappingEncoreInteraction.addTypeToPubmed(encoreInteraction.getTypeToPubmed());
    }

    @Override
    public void saveResultsInMitab(String fileName) throws IOException {
        PsimiTabWriter writer = new PsimiTabWriter();
        File file = new File(fileName);
        Map interactionMapping = this.getInteractionMapping();
        Encore2Binary iConverter = new Encore2Binary(this.getMappingIdDbNames());
        for (Integer mappingId : interactionMapping.keySet()) {
            EncoreInteraction eI = (EncoreInteraction)interactionMapping.get(mappingId);
            BinaryInteraction bI = iConverter.getBinaryInteraction(eI);
            writer.writeOrAppend(bI, file, false);
        }
    }

    public void saveScoreInMitab(String fileName) throws IOException {
        PsimiTabWriter writer = new PsimiTabWriter();
        File file = new File(fileName);
        Map interactionMapping = this.getInteractionMapping();
        Encore2Binary iConverter = new Encore2Binary(this.getMappingIdDbNames());
        for (Integer mappingId : interactionMapping.keySet()) {
            EncoreInteraction eI = (EncoreInteraction)interactionMapping.get(mappingId);
            BinaryInteraction bI = iConverter.getBinaryInteraction(eI);
            writer.writeOrAppend(bI, file, false);
        }
    }

    @Override
    protected void setMappingForBinaryInteractions() {
        super.setMappingForBinaryInteractions();
    }

    public void setQuerySourcesFromPsicquicRegistry() {
        DefaultPsicquicRegistryClient registryClient = new DefaultPsicquicRegistryClient();
        try {
            List allServices = registryClient.listServices();
            for (ServiceType service : allServices) {
                if (!service.isActive()) continue;
                this.addQuerySource(service.getName());
            }
        }
        catch (PsicquicRegistryClientException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
    }

    public void setImexSources() {
        DefaultPsicquicRegistryClient registryClient = new DefaultPsicquicRegistryClient();
        try {
            List allServices = registryClient.listServices();
            for (ServiceType service : allServices) {
                List tags = service.getTags();
                if (!service.isActive() || tags == null || !tags.contains("MI:0959")) continue;
                this.addQuerySource(service.getName());
            }
        }
        catch (PsicquicRegistryClientException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
    }

    public List<String> getQuerySources() {
        return this.querySources;
    }

    public List<String> getQueryAccs() {
        return this.queryAccs;
    }

    public void setBinaryInteractionList(List<BinaryInteraction> binaryInteractionList) {
        this.binaryInteractionIterator = binaryInteractionList.iterator();
    }

    public void setQueryAccs(List<String> queryAccs) {
        this.queryAccs = queryAccs;
    }

    public void addQueryAcc(String queryAcc) {
        this.queryAccs.add(queryAcc);
    }

    public void setQuerySources(List<String> querySources) {
        this.querySources = querySources;
    }

    public void addQuerySource(String querySource) {
        this.querySources.add(querySource);
    }
}

