/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.enfin.mi.cluster;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import psidev.psi.mi.tab.PsimiTabReader;
import psidev.psi.mi.tab.model.BinaryInteraction;
import uk.ac.ebi.enfin.mi.cluster.Binary2Encore;
import uk.ac.ebi.enfin.mi.cluster.BinaryInteractionCluster;
import uk.ac.ebi.enfin.mi.cluster.ClusterContext;
import uk.ac.ebi.enfin.mi.cluster.ClusterServiceException;
import uk.ac.ebi.enfin.mi.cluster.EncoreBinaryInteraction;
import uk.ac.ebi.enfin.mi.cluster.PsicquicService;
import uk.ac.ebi.enfin.mi.cluster.utils.CompositeInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInteractionCluster<T extends EncoreBinaryInteraction>
implements BinaryInteractionCluster<T> {
    private static Logger logger = Logger.getLogger(AbstractInteractionCluster.class);
    protected Map<Integer, T> interactionMapping;
    protected Map<String, List<Integer>> interactorMapping;
    protected Map<String, String> synonymMapping;
    protected int interactionMappingId = 0;
    protected String mappingIdDbNames = "uniprotkb,chebi";
    protected Binary2Encore binary2Encore;
    protected int maxNumerOfQueryRetries = 3;
    protected int maxNumerOfErrorRequests = 50;
    protected int queryStart;
    protected int queryRange;
    protected Iterator<BinaryInteraction> binaryInteractionIterator;

    public AbstractInteractionCluster(List<BinaryInteraction> binaryInteractionList, String mappingIdDbNames) {
        this.binary2Encore = new Binary2Encore();
        this.binaryInteractionIterator = binaryInteractionList.iterator();
        this.setMappingIdDbNames(mappingIdDbNames);
    }

    public AbstractInteractionCluster(List<BinaryInteraction> binaryInteractionList) {
        String[] dbNames = this.mappingIdDbNames.contains(",") ? this.mappingIdDbNames.split(",") : new String[]{this.mappingIdDbNames};
        this.binary2Encore = new Binary2Encore(dbNames);
        this.binaryInteractionIterator = binaryInteractionList.iterator();
    }

    public AbstractInteractionCluster(InputStream is, boolean hasHeader) throws ClusterServiceException {
        this(new InputStreamReader(is), hasHeader);
    }

    public AbstractInteractionCluster(Reader r, boolean hasHeader) throws ClusterServiceException {
        if (r == null) {
            throw new IllegalArgumentException("You must give a non null MITAB Reader");
        }
        String[] dbNames = this.mappingIdDbNames.contains(",") ? this.mappingIdDbNames.split(",") : new String[]{this.mappingIdDbNames};
        this.binary2Encore = new Binary2Encore(dbNames);
        PsimiTabReader reader = new PsimiTabReader(hasHeader);
        try {
            this.binaryInteractionIterator = reader.iterate(r);
        }
        catch (Exception e) {
            throw new ClusterServiceException("An error occured while read MITAB data", e);
        }
    }

    public AbstractInteractionCluster(Iterator<BinaryInteraction> iterator) throws ClusterServiceException {
        if (iterator == null) {
            throw new IllegalArgumentException("You must give a non null iterator");
        }
        this.binaryInteractionIterator = iterator;
        String[] dbNames = this.mappingIdDbNames.contains(",") ? this.mappingIdDbNames.split(",") : new String[]{this.mappingIdDbNames};
        this.binary2Encore = new Binary2Encore(dbNames);
    }

    public AbstractInteractionCluster(int queryStart, int queryRange) {
        this.queryStart = queryStart;
        if (queryRange > 200) {
            logger.warn((Object)("You have set a query range of " + queryRange + " while the maximum supported is 200. Setting it back to 200."));
            this.queryRange = 200;
        } else {
            this.queryRange = queryRange;
        }
        String[] dbNames = this.mappingIdDbNames.contains(",") ? this.mappingIdDbNames.split(",") : new String[]{this.mappingIdDbNames};
        this.binary2Encore = new Binary2Encore(dbNames);
    }

    public AbstractInteractionCluster(int queryStart, int queryRange, String mappingIdDbNames) {
        this.queryStart = queryStart;
        if (queryRange > 200) {
            logger.warn((Object)("You have set a query range of " + queryRange + " while the maximum supported is 200. Setting it back to 200."));
            this.queryRange = 200;
        } else {
            this.queryRange = queryRange;
        }
        this.binary2Encore = new Binary2Encore();
        this.setMappingIdDbNames(mappingIdDbNames);
    }

    public AbstractInteractionCluster(String mappingIdDbNames) {
        this.queryStart = 0;
        this.queryRange = 200;
        this.binary2Encore = new Binary2Encore();
        this.setMappingIdDbNames(mappingIdDbNames);
    }

    @Override
    public void runService() {
        if (this.interactionMapping == null) {
            if (ClusterContext.getInstance().getCacheManager().getInteractionCache().size() > 0) {
                logger.error((Object)"ERROR: CACHE PROBLEM. InteractionCache HAS NOT BEEN RESET");
            }
            this.interactionMapping = ClusterContext.getInstance().getCacheManager().getInteractionCache();
        }
        if (this.interactorMapping == null) {
            if (ClusterContext.getInstance().getCacheManager().getInteractorCache().size() > 0) {
                logger.error((Object)"ERROR: CACHE PROBLEM. InteractorCache HAS NOT BEEN RESET");
            }
            this.interactorMapping = ClusterContext.getInstance().getCacheManager().getInteractorCache();
        }
        if (this.synonymMapping == null) {
            if (ClusterContext.getInstance().getCacheManager().getSynonymCache().size() > 0) {
                logger.error((Object)"ERROR: CACHE PROBLEM. SynonymCache HAS NOT BEEN RESET");
            }
            this.synonymMapping = ClusterContext.getInstance().getCacheManager().getSynonymCache();
        }
        this.setMappingForPsicquic();
        this.setMappingForBinaryInteractions();
    }

    protected void setMappingForBinaryInteractions() {
        if (this.binaryInteractionIterator != null) {
            String[] idDbNameList = this.mappingIdDbNames.split(",");
            while (this.binaryInteractionIterator.hasNext()) {
                BinaryInteraction binaryInteraction = this.binaryInteractionIterator.next();
                this.setMappings(binaryInteraction, idDbNameList);
            }
        }
    }

    protected abstract void setMappingForPsicquic();

    protected void setMappingForPsicquic(String miqlQuery, String querySource) throws IOException {
        if (miqlQuery != null && querySource != null) {
            String[] idDbNameList = this.mappingIdDbNames.split(",");
            int start = this.queryStart;
            int range = this.queryRange;
            int stop = this.queryStart + this.queryRange - 1;
            PsicquicService pService = new PsicquicService(querySource);
            if (pService.getService() != null) {
                int count = 0;
                Integer serviceInteractionCount = pService.countInteractions(miqlQuery);
                if (serviceInteractionCount != null) {
                    count = serviceInteractionCount;
                    logger.debug((Object)("Interaction count for " + querySource + ": " + count));
                }
                int numOfQueries = (int)Math.ceil((double)count / (double)this.queryRange);
                if (logger.isInfoEnabled()) {
                    logger.debug((Object)("Psicquic source: " + pService.getServiceName() + " | Number of psicquic queries: " + numOfQueries + " | Query range: " + this.queryRange + " | Total number of results: " + count));
                }
                int queryTry = 0;
                int queryCount = 0;
                int countErrorRequests = 0;
                boolean countMissingInteractions = false;
                while (queryCount < numOfQueries) {
                    List<BinaryInteraction> searchResult;
                    block15: {
                        start = this.queryStart + this.queryRange * queryCount;
                        stop = start + range - 1;
                        if (stop >= count) {
                            range = count - start;
                            stop = start + range - 1;
                        }
                        if (logger.isInfoEnabled()) {
                            logger.debug((Object)("Psicquic source: " + pService.getServiceName() + " | Query num: " + queryCount + " | start: " + start + ", stop: " + stop + ", range: " + range));
                        }
                        searchResult = null;
                        try {
                            searchResult = pService.getInteractions(miqlQuery, start, range);
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Problem retrieving data from " + pService.getServiceName() + " | Query num: " + queryCount + " | start: " + start + ", stop: " + stop + ", range: " + range));
                            ++countErrorRequests;
                            if (++queryTry == this.maxNumerOfQueryRetries) {
                                queryTry = 0;
                                logger.error((Object)("Problem retrieving data after " + this.maxNumerOfQueryRetries + "attempts from " + pService.getServiceName() + " | Query num: " + ++queryCount + " | start: " + start + ", stop: " + stop + ", range: " + range + ". The program will skip this query and try with the next query."));
                            } else {
                                Thread thisThread = Thread.currentThread();
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                            }
                            if (countErrorRequests <= this.maxNumerOfErrorRequests) break block15;
                            logger.error((Object)("Stop quering " + pService.getServiceName() + "More than " + this.maxNumerOfErrorRequests + "error request"));
                            break;
                        }
                    }
                    if (searchResult == null) continue;
                    if (searchResult.isEmpty()) {
                        logger.warn((Object)("Data inside the psicquic result is empty. Psicquic source: " + pService.getServiceName() + " | Query num: " + queryCount + " | start: " + start + ", stop: " + stop + ", range: " + range));
                        continue;
                    }
                    queryTry = 0;
                    ++queryCount;
                    for (BinaryInteraction interaction : searchResult) {
                        this.setMappings(interaction, idDbNameList);
                    }
                }
            }
        }
    }

    protected abstract T convertEncoreInteractionFrom(BinaryInteraction var1, String[] var2);

    protected void setMappings(BinaryInteraction interaction, String[] idDbNameList) {
        T encoreInteraction = this.convertEncoreInteractionFrom(interaction, idDbNameList);
        if (encoreInteraction != null) {
            Map<String, String> interactorAccsA = encoreInteraction.getInteractorAccsA();
            Map<String, String> interactorAccsB = encoreInteraction.getInteractorAccsB();
            if (!interactorAccsA.isEmpty() || !interactorAccsB.isEmpty()) {
                EncoreBinaryInteraction mappingEcoreInteraction;
                int interactionIdFound;
                List<Object> interactionMappingIdsForInteractorAccB;
                List<Object> interactionMappingIdsForInteractorAccA;
                String interactorAccB;
                String interactorAccA;
                block27: {
                    interactorAccA = null;
                    interactorAccB = null;
                    if (!interactorAccsA.isEmpty() && !interactorAccsB.isEmpty()) {
                        interactorAccA = this.getInteractorFromAccs(interactorAccsA, idDbNameList);
                        interactorAccB = this.getInteractorFromAccs(interactorAccsB, idDbNameList);
                    } else if (!interactorAccsA.isEmpty() && interactorAccsB.isEmpty()) {
                        interactorAccB = interactorAccA = this.getInteractorFromAccs(interactorAccsA, idDbNameList);
                        encoreInteraction.setInteractorAccsB(interactorAccsA);
                        interactorAccsB = interactorAccsA;
                    } else {
                        interactorAccA = interactorAccB = this.getInteractorFromAccs(interactorAccsB, idDbNameList);
                        encoreInteraction.setInteractorAccsA(interactorAccsB);
                        interactorAccsA = interactorAccsB;
                    }
                    interactionMappingIdsForInteractorAccA = new ArrayList();
                    if (this.interactorMapping.containsKey(interactorAccA)) {
                        interactionMappingIdsForInteractorAccA = this.interactorMapping.get(interactorAccA);
                    } else if (this.synonymMapping.containsKey(interactorAccA)) {
                        interactorAccA = this.synonymMapping.get(interactorAccA);
                        interactionMappingIdsForInteractorAccA = this.interactorMapping.get(interactorAccA);
                    }
                    interactionMappingIdsForInteractorAccB = new ArrayList();
                    if (this.interactorMapping.containsKey(interactorAccB)) {
                        interactionMappingIdsForInteractorAccB = this.interactorMapping.get(interactorAccB);
                    } else if (this.synonymMapping.containsKey(interactorAccB)) {
                        interactorAccB = this.synonymMapping.get(interactorAccB);
                        interactionMappingIdsForInteractorAccB = this.interactorMapping.get(interactorAccB);
                    }
                    interactionIdFound = 0;
                    if (interactorAccA.equalsIgnoreCase(interactorAccB)) {
                        if (this.interactorMapping.containsKey(interactorAccA)) {
                            for (Integer n : interactionMappingIdsForInteractorAccA) {
                                mappingEcoreInteraction = (EncoreBinaryInteraction)this.interactionMapping.get(n);
                                Map<String, String> mappingInteractorAccsA = mappingEcoreInteraction.getInteractorAccsA();
                                Map<String, String> mappingInteractorAccsB = mappingEcoreInteraction.getInteractorAccsB();
                                for (String acc : mappingInteractorAccsA.values()) {
                                    if (!mappingInteractorAccsB.values().contains(acc)) continue;
                                    interactionIdFound = n;
                                    break block27;
                                }
                            }
                        }
                    } else {
                        for (Integer n : interactionMappingIdsForInteractorAccA) {
                            if (!interactionMappingIdsForInteractorAccB.contains(n)) continue;
                            interactionIdFound = n;
                            break;
                        }
                    }
                }
                for (String string : encoreInteraction.getInteractorAccsA().values()) {
                    if (this.synonymMapping.containsKey(string) || string.equalsIgnoreCase(interactorAccA)) continue;
                    this.synonymMapping.put(string, interactorAccA);
                }
                for (String string : encoreInteraction.getInteractorAccsB().values()) {
                    if (this.synonymMapping.containsKey(string) || string.equalsIgnoreCase(interactorAccB)) continue;
                    this.synonymMapping.put(string, interactorAccB);
                }
                if (interactionIdFound > 0) {
                    mappingEcoreInteraction = this.mergeWithExistingEncoreInteraction(encoreInteraction, interactionIdFound);
                    this.interactionMapping.put(interactionIdFound, mappingEcoreInteraction);
                } else {
                    ArrayList<Integer> qM;
                    ++this.interactionMappingId;
                    encoreInteraction.setId(this.interactionMappingId);
                    this.interactionMapping.put(this.interactionMappingId, encoreInteraction);
                    if (interactionMappingIdsForInteractorAccA.size() == 0 && interactionMappingIdsForInteractorAccB.size() == 0) {
                        qM = new ArrayList<Integer>();
                        qM.add(this.interactionMappingId);
                        this.interactorMapping.put(interactorAccA, qM);
                        if (!interactorAccA.equalsIgnoreCase(interactorAccB)) {
                            ArrayList<Integer> arrayList = new ArrayList<Integer>();
                            arrayList.add(this.interactionMappingId);
                            this.interactorMapping.put(interactorAccB, arrayList);
                        }
                    }
                    if (interactionMappingIdsForInteractorAccA.size() == 0 && interactionMappingIdsForInteractorAccB.size() > 0) {
                        qM = new ArrayList();
                        qM.add(this.interactionMappingId);
                        this.interactorMapping.put(interactorAccA, qM);
                        List<Object> list = interactionMappingIdsForInteractorAccB;
                        list.add(this.interactionMappingId);
                        this.interactorMapping.put(interactorAccB, list);
                    }
                    if (interactionMappingIdsForInteractorAccA.size() > 0 && interactionMappingIdsForInteractorAccB.size() == 0) {
                        ArrayList<Integer> pM = new ArrayList<Integer>();
                        pM.add(this.interactionMappingId);
                        this.interactorMapping.put(interactorAccB, pM);
                        List<Object> list = interactionMappingIdsForInteractorAccA;
                        list.add(this.interactionMappingId);
                        this.interactorMapping.put(interactorAccA, list);
                    }
                    if (interactionMappingIdsForInteractorAccA.size() > 0 && interactionMappingIdsForInteractorAccB.size() > 0) {
                        List<Object> pA = interactionMappingIdsForInteractorAccB;
                        pA.add(this.interactionMappingId);
                        this.interactorMapping.put(interactorAccB, pA);
                        List<Object> list = interactionMappingIdsForInteractorAccA;
                        list.add(this.interactionMappingId);
                        this.interactorMapping.put(interactorAccA, list);
                    }
                }
            }
        }
    }

    protected T mergeWithExistingEncoreInteraction(T encoreInteraction, int interactionIdFound) {
        EncoreBinaryInteraction mappingEcoreInteraction = (EncoreBinaryInteraction)this.interactionMapping.get(interactionIdFound);
        if (mappingEcoreInteraction == null) {
            throw new IllegalStateException("Could not find an EncoreInteraction with id: " + interactionIdFound);
        }
        boolean swapInteractors = true;
        for (String acc : mappingEcoreInteraction.getInteractorAccsA().values()) {
            if (!encoreInteraction.getInteractorAccsA().containsValue(acc)) continue;
            swapInteractors = false;
            break;
        }
        if (swapInteractors) {
            mappingEcoreInteraction.addInteractorAccsA(encoreInteraction.getInteractorAccsB());
            mappingEcoreInteraction.addInteractorAccsB(encoreInteraction.getInteractorAccsA());
            mappingEcoreInteraction.addOtherInteractorAccsA(encoreInteraction.getOtherInteractorAccsB());
            mappingEcoreInteraction.addOtherInteractorAccsB(encoreInteraction.getOtherInteractorAccsA());
            mappingEcoreInteraction.addOrganismsA(encoreInteraction.getOrganismsB());
            mappingEcoreInteraction.addOrganismsB(encoreInteraction.getOrganismsA());
        } else {
            mappingEcoreInteraction.addInteractorAccsA(encoreInteraction.getInteractorAccsA());
            mappingEcoreInteraction.addInteractorAccsB(encoreInteraction.getInteractorAccsB());
            mappingEcoreInteraction.addOtherInteractorAccsA(encoreInteraction.getOtherInteractorAccsA());
            mappingEcoreInteraction.addOtherInteractorAccsB(encoreInteraction.getOtherInteractorAccsB());
            mappingEcoreInteraction.addOrganismsA(encoreInteraction.getOrganismsA());
            mappingEcoreInteraction.addOrganismsB(encoreInteraction.getOrganismsB());
        }
        mappingEcoreInteraction.addPublicationId(encoreInteraction.getPublicationIds());
        mappingEcoreInteraction.addExperimentToPubmed(encoreInteraction.getExperimentToPubmed());
        mappingEcoreInteraction.addExperimentToDatabase(encoreInteraction.getExperimentToDatabase());
        this.processMethodAndType(encoreInteraction, mappingEcoreInteraction);
        mappingEcoreInteraction.addAuthors(encoreInteraction.getAuthors());
        mappingEcoreInteraction.addConfidenceValues(encoreInteraction.getConfidenceValues());
        mappingEcoreInteraction.addSourceDatabases(encoreInteraction.getSourceDatabases());
        return (T)mappingEcoreInteraction;
    }

    protected abstract void processMethodAndType(T var1, T var2);

    protected String getInteractorFromAccs(Map<String, String> interactorAccs, String[] idDbNameList) {
        String interactorAcc = null;
        for (String idDbName : idDbNameList) {
            if (!interactorAccs.containsKey(idDbName)) continue;
            interactorAcc = interactorAccs.get(idDbName);
            break;
        }
        if (interactorAcc == null) {
            interactorAcc = interactorAccs.values().iterator().next();
        }
        return interactorAcc;
    }

    @Override
    public Map<Integer, T> getInteractionMapping() {
        return this.interactionMapping;
    }

    @Override
    public void setInteractionMapping(Map<Integer, T> interactionMapping) {
        this.interactionMapping = interactionMapping;
    }

    @Override
    public Map<String, List<Integer>> getInteractorMapping() {
        return this.interactorMapping;
    }

    @Override
    public void setInteractorMapping(Map<String, List<Integer>> interactorMapping) {
        this.interactorMapping = interactorMapping;
    }

    @Override
    public int getInteractionMappingId() {
        return this.interactionMappingId;
    }

    @Override
    public void setInteractionMappingId(int interactionMappingId) {
        this.interactionMappingId = interactionMappingId;
    }

    @Override
    public Map<String, String> getSynonymMapping() {
        return this.synonymMapping;
    }

    @Override
    public void setSynonymMapping(Map<String, String> synonymMapping) {
        this.synonymMapping = synonymMapping;
    }

    @Override
    public void setMappingIdDbNames(String mappingIdDbNames) {
        if (mappingIdDbNames != null) {
            this.mappingIdDbNames = mappingIdDbNames;
            String[] dbNames = mappingIdDbNames.contains(",") ? mappingIdDbNames.split(",") : new String[]{mappingIdDbNames};
            this.binary2Encore.setIdDbNameList(dbNames);
        } else {
            logger.warn((Object)("mappingIdDbNames can not be null. Setting the default mappingIdDbNames: " + this.mappingIdDbNames));
        }
    }

    @Override
    public String getMappingIdDbNames() {
        return this.mappingIdDbNames;
    }

    @Override
    public Iterator<BinaryInteraction> getBinaryInteractionIterator() {
        return this.binaryInteractionIterator;
    }

    @Override
    public void setBinaryInteractionIterator(Iterator<BinaryInteraction> binaryInteractionIterator) {
        this.binaryInteractionIterator = binaryInteractionIterator;
    }

    @Override
    public void setBinaryInteractionIterator(InputStream inputStream, boolean hasHeader) throws ClusterServiceException {
        this.setBinaryInteractionIterator(new InputStreamReader(inputStream), hasHeader);
    }

    public void setBinaryInteractionIterator(File file, boolean hasHeader) throws ClusterServiceException {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ClusterServiceException("No file found", e);
        }
        this.setBinaryInteractionIterator(new InputStreamReader(inputStream), hasHeader);
    }

    public void setBinaryInteractionIterator(File[] files, boolean hasHeader) throws ClusterServiceException {
        CompositeInputStream inputStream;
        ArrayList<FileInputStream> streams = new ArrayList<FileInputStream>();
        for (File file : files) {
            try {
                streams.add(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                throw new ClusterServiceException("No file found", e);
            }
        }
        try {
            inputStream = new CompositeInputStream(streams.iterator());
        }
        catch (IOException e) {
            throw new ClusterServiceException("Input error", e);
        }
        this.setBinaryInteractionIterator(new InputStreamReader(inputStream), hasHeader);
    }

    @Override
    public void setBinaryInteractionIterator(Reader r, boolean hasHeader) throws ClusterServiceException {
        if (r != null) {
            PsimiTabReader reader = new PsimiTabReader(hasHeader);
            try {
                this.binaryInteractionIterator = reader.iterate(r);
            }
            catch (Exception e) {
                throw new ClusterServiceException("An error occured while read MITAB data", e);
            }
        }
    }

    @Override
    public abstract void saveResultsInMitab(String var1) throws IOException;
}

