/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.xmlindex;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import psidev.psi.mi.xml.PsimiXmlReaderException;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.ExperimentalInteractor;
import psidev.psi.mi.xml.model.ExperimentalPreparation;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Feature;
import psidev.psi.mi.xml.model.HostOrganism;
import psidev.psi.mi.xml.model.InferredInteraction;
import psidev.psi.mi.xml.model.InferredInteractionParticipant;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.InteractionRef;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.InteractorRef;
import psidev.psi.mi.xml.model.Parameter;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.ParticipantIdentificationMethod;
import psidev.psi.mi.xml.xmlindex.InputStreamRange;
import psidev.psi.mi.xml.xmlindex.PsimiXmlFileIndex;
import psidev.psi.mi.xml.xmlindex.PsimiXmlPullParser;
import psidev.psi.tools.xxindex.StandardXmlElementExtractor;

public class PsimiXmlExtractor {
    PsimiXmlPullParser ppp;
    private PsimiXmlFileIndex index;
    private Map<Integer, ExperimentDescription> experimentCache = new HashMap<Integer, ExperimentDescription>();

    public PsimiXmlExtractor(PsimiXmlFileIndex index, PsimiXmlPullParser psimiXmlPullParser) {
        if (index == null) {
            throw new IllegalArgumentException("You must give a non null index.");
        }
        this.index = index;
        this.ppp = psimiXmlPullParser;
    }

    public ExperimentDescription getExperimentById(File fis, int id) throws PsimiXmlReaderException {
        ExperimentDescription ed = this.experimentCache.get(id);
        if (ed == null) {
            InputStreamRange range = this.index.getExperimentPosition(id);
            if (range == null) {
                throw new PsimiXmlReaderException("Could not find a range in the index for experiment id:" + id);
            }
            InputStream eis = null;
            try {
                eis = PsimiXmlExtractor.extractXmlSnippet(fis, range);
            }
            catch (IOException e) {
                throw new PsimiXmlReaderException("Error while extracting XML snippet for experiment", e);
            }
            ed = this.ppp.parseExperiment(eis);
            this.experimentCache.put(id, ed);
        }
        return ed;
    }

    public void clearExperimentCache() {
        this.experimentCache.clear();
    }

    public Interactor getInteractorById(File fis, int id) throws PsimiXmlReaderException {
        InputStreamRange range = this.index.getInteractorPosition(id);
        if (range == null) {
            throw new PsimiXmlReaderException("Could not find a range in the index for interactor id:" + id);
        }
        InputStream is = null;
        try {
            is = PsimiXmlExtractor.extractXmlSnippet(fis, range);
        }
        catch (IOException e) {
            throw new PsimiXmlReaderException("Error while extracting XML snippet for interactor", e);
        }
        return this.ppp.parseInteractor(is);
    }

    public Feature getFeatureById(File fis, int id) throws PsimiXmlReaderException {
        InputStreamRange range = this.index.getFeaturePosition(id);
        if (range == null) {
            throw new PsimiXmlReaderException("Could not find a range in the index for feature id:" + id);
        }
        InputStream is = null;
        try {
            is = PsimiXmlExtractor.extractXmlSnippet(fis, range);
        }
        catch (IOException e) {
            throw new PsimiXmlReaderException("Error while extracting XML snippet for feature", e);
        }
        return this.ppp.parseFeature(is);
    }

    public Participant getParticipantById(File fis, int id) throws PsimiXmlReaderException {
        InputStreamRange range = this.index.getParticipantPosition(id);
        if (range == null) {
            throw new PsimiXmlReaderException("Could not find a range in the index for participant id:" + id);
        }
        InputStream is = null;
        try {
            is = PsimiXmlExtractor.extractXmlSnippet(fis, range);
        }
        catch (IOException e) {
            throw new PsimiXmlReaderException("Error while extracting XML snippet for participant", e);
        }
        return this.ppp.parseParticipant(is);
    }

    public Interaction getInteractionById(File fis, int id) throws PsimiXmlReaderException {
        InputStreamRange range = this.index.getInteractionPosition(id);
        if (range == null) {
            throw new PsimiXmlReaderException("Could not find a range in the index for interaction id:" + id);
        }
        InputStream is = null;
        try {
            is = PsimiXmlExtractor.extractXmlSnippet(fis, range);
        }
        catch (IOException e) {
            throw new PsimiXmlReaderException("Error while getting interaction by id: " + id, e);
        }
        return this.ppp.parseInteraction(is);
    }

    public void resolveReferences(File file, Interaction interaction) throws PsimiXmlReaderException {
        ExperimentDescription ed;
        if (interaction.hasExperimentRefs()) {
            Iterator<ExperimentRef> itex = interaction.getExperimentRefs().iterator();
            while (itex.hasNext()) {
                ExperimentRef eref = itex.next();
                ExperimentDescription ed2 = this.getExperimentById(file, eref.getRef());
                if (ed2 == null) {
                    throw new PsimiXmlReaderException("The interaction " + interaction.getId() + " refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                }
                itex.remove();
                interaction.getExperiments().add(ed2);
            }
        }
        for (Participant p : interaction.getParticipants()) {
            this.resolveReferences(file, p, interaction);
        }
        if (interaction.hasInferredInteractions()) {
            for (InferredInteraction ii : interaction.getInferredInteractions()) {
                if (ii.hasExperimentRefs()) {
                    for (ExperimentRef eref : ii.getExperimentRefs()) {
                        if (!interaction.getExperiments().isEmpty()) {
                            ed = this.findExperimentDescriptionInInteraction(eref, interaction);
                            if (ed != null) {
                                ii.getExperiments().add(ed);
                                continue;
                            }
                            throw new PsimiXmlReaderException("An interaction (id=" + interaction.getId() + ") contains an inferredInteraction which refers to experiment ref " + eref.getRef() + "," + "however, this experiment isn't defined in this interaction." + " This is not a supported use of the PSI-MI XML format.");
                        }
                        ed = this.getExperimentById(file, eref.getRef());
                        if (ed == null) {
                            throw new PsimiXmlReaderException("The interaction " + interaction.getId() + " has an inferred interaction which refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                        }
                        ii.getExperiments().add(ed);
                    }
                    ii.getExperimentRefs().clear();
                }
                for (InferredInteractionParticipant iip : ii.getParticipant()) {
                    InputStreamRange r;
                    if (iip.hasFeatureRef()) {
                        r = this.index.getFeaturePosition(iip.getFeatureRef().getRef());
                        InputStream pfis = null;
                        try {
                            pfis = PsimiXmlExtractor.extractXmlSnippet(file, r);
                        }
                        catch (IOException e) {
                            throw new PsimiXmlReaderException("Error while extracting XML snippet for feature", e);
                        }
                        Feature ft = this.ppp.parseFeature(pfis);
                        if (ft == null) {
                            throw new PsimiXmlReaderException("The interaction " + interaction.getId() + " has an inferred interaction participant which refers to the feature " + iip.getFeatureRef().getRef() + " but this feature cannot be found by the parser." + " Please check that you have described this feature previously in this interaction.");
                        }
                        iip.setFeatureRef(null);
                        iip.setFeature(ft);
                    }
                    if (!iip.hasParticipantRef()) continue;
                    r = this.index.getParticipantPosition(iip.getParticipantRef().getRef());
                    InputStream pis = null;
                    try {
                        pis = PsimiXmlExtractor.extractXmlSnippet(file, r);
                    }
                    catch (IOException e) {
                        throw new PsimiXmlReaderException("Error while extracting XML snippet for participant", e);
                    }
                    Participant p = this.ppp.parseParticipant(pis);
                    if (p == null) {
                        throw new PsimiXmlReaderException("The interaction " + interaction.getId() + " has an inferred interaction which refers to the participant " + iip.getParticipantRef().getRef() + " but this participant cannot be found by the parser." + " Please check that you have described the participant in this interaction.");
                    }
                    iip.setParticipantRef(null);
                    iip.setParticipant(p);
                }
            }
        }
        if (interaction.hasConfidences()) {
            for (Confidence conf : interaction.getConfidences()) {
                if (!conf.hasExperimentRefs()) continue;
                for (ExperimentRef eref : conf.getExperimentRefs()) {
                    if (!interaction.getExperiments().isEmpty()) {
                        ed = this.findExperimentDescriptionInInteraction(eref, interaction);
                        if (ed != null) {
                            conf.getExperiments().add(ed);
                            continue;
                        }
                        throw new PsimiXmlReaderException("The interaction (id=" + interaction.getId() + ") has a confidence which refers to experiment ref " + eref.getRef() + "," + "however, this experiment isn't defined in this interaction." + " This is not a supported use of the PSI-MI XML format.");
                    }
                    ed = this.getExperimentById(file, eref.getRef());
                    if (ed == null) {
                        throw new PsimiXmlReaderException("The interaction " + interaction.getId() + " has a confidence which refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                    }
                    conf.getExperiments().add(ed);
                }
                conf.getExperimentRefs().clear();
            }
        }
        if (interaction.hasParameters()) {
            for (Parameter pm : interaction.getParameters()) {
                ExperimentDescription ed3;
                if (!pm.hasExperimentRef()) continue;
                ExperimentRef eref = pm.getExperimentRef();
                if (!interaction.getExperiments().isEmpty()) {
                    ed3 = this.findExperimentDescriptionInInteraction(eref, interaction);
                    if (ed3 != null) {
                        pm.setExperimentRef(null);
                        pm.setExperiment(ed3);
                        continue;
                    }
                    throw new PsimiXmlReaderException("A parameter (" + pm.getTerm() + ") defined in interaction (id=" + interaction.getId() + ") refers to experiment ref " + eref.getRef() + "," + "however, this experiment isn't defined in this interaction." + " This is not a supported use of the PSI-MI XML format.");
                }
                ed3 = this.getExperimentById(file, eref.getRef());
                if (ed3 == null) {
                    throw new PsimiXmlReaderException("The interaction " + interaction.getId() + " has a parameter which refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                }
                pm.setExperimentRef(null);
                pm.setExperiment(ed3);
            }
        }
    }

    private ExperimentDescription findExperimentDescriptionInInteraction(ExperimentRef eref, Interaction i) {
        for (ExperimentDescription ed : i.getExperiments()) {
            if (ed.getId() != eref.getRef()) continue;
            return ed;
        }
        return null;
    }

    public void resolveReferences(File fis, Participant participant, Interaction parentInteraction) throws PsimiXmlReaderException {
        ExperimentDescription ed;
        if (participant.hasInteractionRef()) {
            InteractionRef ref = participant.getInteractionRef();
            participant.setInteractionRef(null);
            if (parentInteraction != null) {
                if (ref.getRef() == parentInteraction.getId()) {
                    throw new PsimiXmlReaderException("The interaction " + ref.getRef() + " has a participant (" + participant.getId() + ") which is an interaction and this interaction is referring to itself." + " It is not a valid participant.");
                }
                Interaction i = this.getInteractionById(fis, ref.getRef());
                if (i == null) {
                    throw new PsimiXmlReaderException("The participant " + participant.getId() + " refers to the interaction " + ref.getRef() + " but this interaction cannot be found by the parser. Please check that this interaction is described somewhere in the list of interactions.");
                }
                this.resolveReferences(fis, i);
                participant.setInteraction(i);
            } else {
                throw new PsimiXmlReaderException("The  participant (" + participant.getId() + ") doesn't have any interactions attached to it.");
            }
        }
        boolean hasInteractionExperimentDescription = false;
        if (parentInteraction != null && !parentInteraction.getExperiments().isEmpty()) {
            hasInteractionExperimentDescription = true;
        }
        if (participant.hasInteractorRef()) {
            InteractorRef ref = participant.getInteractorRef();
            InputStreamRange irange = this.index.getInteractorPosition(ref.getRef());
            InputStream iis = null;
            try {
                iis = PsimiXmlExtractor.extractXmlSnippet(fis, irange);
            }
            catch (IOException e) {
                throw new PsimiXmlReaderException("Error while extracting XML snippet for interactor", e);
            }
            Interactor interactor = this.ppp.parseInteractor(iis);
            if (interactor == null) {
                throw new PsimiXmlReaderException("The participant " + participant.getId() + " refers to the interactor " + ref.getRef() + " but this interactior cannot be found by the parser. " + "Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the interactors are described at the beginning of the file and" + " all the participants then use references to pre-declared interactors or all the interactors are only described at the level of the participants and no interactor reference can be used.");
            }
            participant.setInteractorRef(null);
            participant.setInteractor(interactor);
        }
        if (participant.hasParticipantIdentificationMethods()) {
            for (ParticipantIdentificationMethod pim : participant.getParticipantIdentificationMethods()) {
                if (!pim.hasExperimentRefs()) continue;
                if (hasInteractionExperimentDescription && !parentInteraction.getExperiments().isEmpty()) {
                    for (ExperimentRef eref : pim.getExperimentRefs()) {
                        ed = this.findExperimentDescriptionInInteraction(eref, parentInteraction);
                        if (ed != null) {
                            pim.getExperiments().add(ed);
                            continue;
                        }
                        throw new PsimiXmlReaderException("The participant (" + participant.getId() + ") defined in interaction (id=" + parentInteraction.getId() + ") has a participant identification method which refers to experiment ref " + eref.getRef() + "," + "however, this experiment isn't defined in this interaction." + " This is not a supported use of the PSI-MI XML format.");
                    }
                    pim.getExperimentRefs().clear();
                    continue;
                }
                for (ExperimentRef eref : pim.getExperimentRefs()) {
                    ed = this.getExperimentById(fis, eref.getRef());
                    if (ed == null) {
                        throw new PsimiXmlReaderException("The participant " + participant.getId() + " has a participant identification method which refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                    }
                    pim.getExperiments().add(ed);
                }
                pim.getExperimentRefs().clear();
            }
        }
        if (participant.hasExperimentalRoles()) {
            for (ExperimentalRole er : participant.getExperimentalRoles()) {
                if (!er.hasExperimentRefs()) continue;
                if (hasInteractionExperimentDescription && !parentInteraction.getExperiments().isEmpty()) {
                    for (ExperimentRef eref : er.getExperimentRefs()) {
                        ed = this.findExperimentDescriptionInInteraction(eref, parentInteraction);
                        if (ed != null) {
                            er.getExperiments().add(ed);
                            continue;
                        }
                        throw new PsimiXmlReaderException("The participant (" + participant.getId() + ") defined in interaction (id=" + parentInteraction.getId() + ") has an experimental role which refers to experiment ref " + eref.getRef() + "," + "however, this experiment isn't defined in this interaction." + " This is not a supported use of the PSI-MI XML format.");
                    }
                    er.getExperimentRefs().clear();
                    continue;
                }
                for (ExperimentRef eref : er.getExperimentRefs()) {
                    ed = this.getExperimentById(fis, eref.getRef());
                    if (ed == null) {
                        throw new PsimiXmlReaderException("The participant " + participant.getId() + " has an experimental role which refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                    }
                    er.getExperiments().add(ed);
                }
                er.getExperimentRefs().clear();
            }
        }
        if (participant.hasExperimentalPreparations()) {
            for (ExperimentalPreparation ep : participant.getExperimentalPreparations()) {
                if (!ep.hasExperimentRefs()) continue;
                if (hasInteractionExperimentDescription && !parentInteraction.getExperiments().isEmpty()) {
                    for (ExperimentRef eref : ep.getExperimentRefs()) {
                        ed = this.findExperimentDescriptionInInteraction(eref, parentInteraction);
                        if (ed != null) {
                            ep.getExperiments().add(ed);
                            continue;
                        }
                        throw new PsimiXmlReaderException("The participant (" + participant.getId() + ") defined in interaction (id=" + parentInteraction.getId() + ") has an experimental preparation which refers to experiment ref " + eref.getRef() + "," + "however, this experiment isn't defined in this interaction." + " This is not a supported use of the PSI-MI XML format.");
                    }
                    ep.getExperimentRefs().clear();
                    continue;
                }
                for (ExperimentRef eref : ep.getExperimentRefs()) {
                    ed = this.getExperimentById(fis, eref.getRef());
                    if (ed == null) {
                        throw new PsimiXmlReaderException("The participant " + participant.getId() + " has an experimental preparation which refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                    }
                    ep.getExperiments().add(ed);
                }
                ep.getExperimentRefs().clear();
            }
        }
        if (participant.hasExperimentalInteractors()) {
            for (ExperimentalInteractor ei : participant.getExperimentalInteractors()) {
                if (ei.hasExperimentRefs()) {
                    if (hasInteractionExperimentDescription && !parentInteraction.getExperiments().isEmpty()) {
                        for (ExperimentRef eref : ei.getExperimentRefs()) {
                            ed = this.findExperimentDescriptionInInteraction(eref, parentInteraction);
                            if (ed != null) {
                                ei.getExperiments().add(ed);
                                continue;
                            }
                            throw new PsimiXmlReaderException("The participant (" + participant.getId() + ") defined in interaction (id=" + parentInteraction.getId() + ") has an experimental interactor which refers to experiment ref " + eref.getRef() + "," + "however, this experiment isn't defined in this interaction." + " This is not a supported use of the PSI-MI XML format.");
                        }
                        ei.getExperimentRefs().clear();
                    } else {
                        for (ExperimentRef eref : ei.getExperimentRefs()) {
                            ed = this.getExperimentById(fis, eref.getRef());
                            if (ed == null) {
                                throw new PsimiXmlReaderException("The participant " + participant.getId() + " has an experimental interactor which refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                            }
                            ei.getExperiments().add(ed);
                        }
                        ei.getExperimentRefs().clear();
                    }
                }
                if (!ei.hasInteractorRef()) continue;
                InteractorRef ref = ei.getInteractorRef();
                InputStreamRange irange = this.index.getInteractorPosition(ref.getRef());
                InputStream iis = null;
                try {
                    iis = PsimiXmlExtractor.extractXmlSnippet(fis, irange);
                }
                catch (IOException e) {
                    throw new PsimiXmlReaderException("Error while extracting XML snippet for interactor", e);
                }
                Interactor interactor = this.ppp.parseInteractor(iis);
                if (interactor == null) {
                    throw new PsimiXmlReaderException("The participant " + participant.getId() + " has an experimental interactor which refers to the interactor " + ref.getRef() + " but this interactor cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the interactors are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared interactors or all the interactors are only described at the level of the participant and no interactor reference can be used.");
                }
                ei.setInteractorRef(null);
                ei.setInteractor(interactor);
            }
        }
        if (participant.hasHostOrganisms()) {
            for (HostOrganism ho : participant.getHostOrganisms()) {
                if (!ho.hasExperimentRefs()) continue;
                if (hasInteractionExperimentDescription && !parentInteraction.getExperiments().isEmpty()) {
                    for (ExperimentRef eref : ho.getExperimentRefs()) {
                        ed = this.findExperimentDescriptionInInteraction(eref, parentInteraction);
                        if (ed != null) {
                            ho.getExperiments().add(ed);
                            continue;
                        }
                        throw new PsimiXmlReaderException("The participant (" + participant.getId() + ") defined in interaction (id=" + parentInteraction.getId() + ") has an organism which refers to experiment ref " + eref.getRef() + "," + "however, this experiment isn't defined in this interaction." + " This is not a supported use of the PSI-MI XML format.");
                    }
                    ho.getExperimentRefs().clear();
                    continue;
                }
                for (ExperimentRef eref : ho.getExperimentRefs()) {
                    ed = this.getExperimentById(fis, eref.getRef());
                    if (ed == null) {
                        throw new PsimiXmlReaderException("The participant " + participant.getId() + " has a host organism which refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                    }
                    ho.getExperiments().add(ed);
                }
                ho.getExperimentRefs().clear();
            }
        }
        if (participant.hasConfidences()) {
            for (Confidence c : participant.getConfidenceList()) {
                if (!c.hasExperimentRefs()) continue;
                if (hasInteractionExperimentDescription && !parentInteraction.getExperiments().isEmpty()) {
                    for (ExperimentRef eref : c.getExperimentRefs()) {
                        ed = this.findExperimentDescriptionInInteraction(eref, parentInteraction);
                        if (ed != null) {
                            c.getExperiments().add(ed);
                            continue;
                        }
                        throw new PsimiXmlReaderException("The participant (" + participant.getId() + ") defined in interaction (id=" + parentInteraction.getId() + ") has a confidence which refers to experiment ref " + eref.getRef() + "," + "however, this experiment isn't defined in this interaction." + " This is not a supported use of the PSI-MI XML format.");
                    }
                    c.getExperimentRefs().clear();
                    continue;
                }
                for (ExperimentRef eref : c.getExperimentRefs()) {
                    ed = this.getExperimentById(fis, eref.getRef());
                    if (ed == null) {
                        throw new PsimiXmlReaderException("The participant " + participant.getId() + " has a confidence score which refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                    }
                    c.getExperiments().add(ed);
                }
                c.getExperimentRefs().clear();
            }
        }
        if (participant.hasParameters()) {
            for (Parameter pm : participant.getParameters()) {
                ExperimentDescription ed2;
                if (!pm.hasExperimentRef()) continue;
                ExperimentRef eref = pm.getExperimentRef();
                if (hasInteractionExperimentDescription && !parentInteraction.getExperiments().isEmpty()) {
                    ed2 = this.findExperimentDescriptionInInteraction(eref, parentInteraction);
                    if (ed2 != null) {
                        pm.setExperiment(ed2);
                        pm.setExperimentRef(null);
                        continue;
                    }
                    throw new PsimiXmlReaderException("The participant (" + participant.getId() + ") defined in interaction (id=" + parentInteraction.getId() + ") has a parameter which refers to experiment ref " + eref.getRef() + "," + "however, this experiment isn't defined in this interaction." + " This is not a supported use of the PSI-MI XML format.");
                }
                ed2 = this.getExperimentById(fis, eref.getRef());
                pm.setExperiment(ed2);
                if (ed2 == null) {
                    throw new PsimiXmlReaderException("The participant " + participant.getId() + " has a parameter which refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                }
                pm.setExperimentRef(null);
            }
        }
        if (participant.hasFeatures()) {
            for (Feature feature : participant.getFeatures()) {
                if (!feature.hasExperimentRefs()) continue;
                if (hasInteractionExperimentDescription && !parentInteraction.getExperiments().isEmpty()) {
                    for (ExperimentRef eref : feature.getExperimentRefs()) {
                        ed = this.findExperimentDescriptionInInteraction(eref, parentInteraction);
                        if (ed != null) {
                            feature.getExperiments().add(ed);
                            continue;
                        }
                        throw new PsimiXmlReaderException("The feature (" + feature.getId() + ") defined in the participant (id=" + participant.getId() + ") of the interaction (id=" + parentInteraction.getId() + ") refers to experiment ref " + eref.getRef() + "," + "however, this experiment isn't defined in this interaction." + " This is not a supported use of the PSI-MI XML format.");
                    }
                    feature.getExperimentRefs().clear();
                    continue;
                }
                for (ExperimentRef eref : feature.getExperimentRefs()) {
                    ed = this.getExperimentById(fis, eref.getRef());
                    if (ed == null) {
                        throw new PsimiXmlReaderException("The participant " + participant.getId() + " has a feature which refers to the experiment " + eref.getRef() + " but this experiment cannot be found by the parser." + " Please check that you are not mixing the expanded PSI xml schema and the compact PSI xml schema together. Either all the experiments are described at the beginning of the file and" + " all the interactions and participants then use references to pre-declared experiments or all the experiments are only described at the level of the interactions and no experiment reference can be used.");
                    }
                    feature.getExperiments().add(ed);
                }
                feature.getExperimentRefs().clear();
            }
        }
    }

    public static InputStream extractXmlSnippet(File file, InputStreamRange range) throws IOException {
        if (range == null) {
            throw new IllegalArgumentException("You must give a non null InputStreamRange.");
        }
        StandardXmlElementExtractor xee = new StandardXmlElementExtractor();
        byte[] bytes = xee.readBytes(range.getFromPosition(), range.getToPosition(), file);
        return new ByteArrayInputStream(bytes);
    }
}

