/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.xmlindex;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import psidev.psi.mi.xml.PsimiXmlReaderRuntimeException;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.xmlindex.InputStreamRange;
import psidev.psi.mi.xml.xmlindex.PsimiXmlExtractor;
import psidev.psi.mi.xml.xmlindex.PsimiXmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentIterator
implements Iterator<ExperimentDescription> {
    private File file;
    private PsimiXmlPullParser parser;
    private Iterator<InputStreamRange> iterator;

    public ExperimentIterator(List<InputStreamRange> ranges, File file, PsimiXmlPullParser parser) {
        if (ranges == null) {
            throw new IllegalArgumentException("You must give a non null List<InputStreamRange>");
        }
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null XML File");
        }
        if (parser == null) {
            throw new IllegalArgumentException("You must give a non null parser");
        }
        this.file = file;
        this.iterator = ranges.iterator();
        this.parser = parser;
    }

    private ExperimentDescription getExperimentByRange(InputStreamRange range) {
        ExperimentDescription interactor;
        try {
            FileInputStream fis = new FileInputStream(this.file);
            InputStream snippetStream = PsimiXmlExtractor.extractXmlSnippet(this.file, range);
            interactor = this.parser.parseExperiment(snippetStream);
        }
        catch (Exception e) {
            throw new PsimiXmlReaderRuntimeException("An error occured while parsing experiment", e);
        }
        return interactor;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ExperimentDescription next() {
        InputStreamRange range = this.iterator.next();
        return this.getExperimentByRange(range);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("ExperimentDescription iterator is read only, you cannot remove elements.");
    }
}

