/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.tutorial;

import java.io.File;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.PsimiXmlWriter;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.Participant;

public class PsimiXmlReaderExample {
    public static void main(String[] args) throws Exception {
        PsimiXmlReader pr = new PsimiXmlReader();
        EntrySet entrySet = pr.read(new File("path/to/data.xml"));
        for (Entry entry : entrySet.getEntries()) {
            for (Interaction interaction : entry.getInteractions()) {
                System.out.println(interaction.getNames().getShortLabel());
                for (Participant participant : interaction.getParticipants()) {
                    Interactor interactor = participant.getInteractor();
                    String name = interactor.getNames().getShortLabel();
                    String type = interactor.getInteractorType().getNames().getShortLabel();
                    String role = "none";
                    if (participant.hasBiologicalRole()) {
                        role = participant.getBiologicalRole().getNames().getShortLabel();
                    }
                    System.out.println(type + ": " + name + " (" + role + ")");
                }
            }
        }
        PsimiXmlWriter pw = new PsimiXmlWriter();
        pw.write(entrySet, new File("path/to/output.xml"));
    }
}

