/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.io.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.PsimiXmlWriterException;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl254.EntrySetConverter;
import psidev.psi.mi.xml.dao.inMemory.InMemoryDAOFactory;
import psidev.psi.mi.xml.io.PsimiXmlWriter;
import psidev.psi.mi.xml.util.PsiJaxbConverter;
import psidev.psi.mi.xml254.jaxb.EntrySet;
import psidev.psi.mi.xml254.jaxb.ObjectFactory;

public class PsimiXmlWriter254
implements PsimiXmlWriter {
    public static final Log log = LogFactory.getLog(PsimiXmlWriter254.class);

    private Marshaller getMarshaller(EntrySet jEntrySet) throws PsimiXmlWriterException {
        try {
            ClassLoader cl = ObjectFactory.class.getClassLoader();
            JAXBContext jc = JAXBContext.newInstance((String)EntrySet.class.getPackage().getName(), (ClassLoader)cl);
            DatatypeConverter.setDatatypeConverter((DatatypeConverterInterface)new PsiJaxbConverter());
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.schemaLocation", (Object)PsimiXmlWriter254.calculateSchemaLocation(jEntrySet.getLevel(), jEntrySet.getVersion(), jEntrySet.getMinorVersion()));
            return marshaller;
        }
        catch (Exception e) {
            throw new PsimiXmlWriterException("En error occured while writing EntrySet", e);
        }
    }

    private void marshall(EntrySet jEntrySet, OutputStream os) throws PsimiXmlWriterException {
        if (os == null) {
            throw new IllegalArgumentException("You must give a non null otuput stream.");
        }
        try {
            Marshaller m = this.getMarshaller(jEntrySet);
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)jEntrySet, os);
        }
        catch (Exception e) {
            throw new PsimiXmlWriterException("En error occured while writing EntrySet", e);
        }
    }

    private void marshall(EntrySet jEntrySet, Writer writer) throws PsimiXmlWriterException {
        if (writer == null) {
            throw new IllegalArgumentException("You must give a non null writer.");
        }
        try {
            Marshaller m = this.getMarshaller(jEntrySet);
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)jEntrySet, writer);
        }
        catch (Exception e) {
            throw new PsimiXmlWriterException("En error occured while writing EntrySet", e);
        }
    }

    private void marshall(EntrySet jEntrySet, File file) throws PsimiXmlWriterException {
        try {
            Marshaller m = this.getMarshaller(jEntrySet);
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)jEntrySet, (Writer)new FileWriter(file));
        }
        catch (Exception e) {
            throw new PsimiXmlWriterException("En error occured while writing EntrySet", e);
        }
    }

    private String marshall(EntrySet jEntrySet) throws PsimiXmlWriterException {
        StringWriter writer = new StringWriter(4096);
        try {
            Marshaller marshaller = this.getMarshaller(jEntrySet);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)jEntrySet, (Writer)writer);
            ((Writer)writer).close();
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            throw new PsimiXmlWriterException("En error occured while writing EntrySet", e);
        }
    }

    private EntrySet convertInMemory(psidev.psi.mi.xml.model.EntrySet mEntrySet) throws PsimiXmlWriterException {
        EntrySetConverter converter = new EntrySetConverter();
        InMemoryDAOFactory dao = new InMemoryDAOFactory();
        converter.setDAOFactory(dao);
        try {
            EntrySet jEntrySet = converter.toJaxb(mEntrySet);
            return jEntrySet;
        }
        catch (Exception e) {
            throw new PsimiXmlWriterException("En error occured while writing EntrySet", e);
        }
    }

    public void write(psidev.psi.mi.xml.model.EntrySet mEntrySet, File file) throws PsimiXmlWriterException {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file.");
        }
        if (file.exists()) {
            log.warn((Object)(file.getAbsolutePath() + " is going to be overwritten"));
            if (!file.canWrite()) {
                throw new IllegalArgumentException("You must give a writeable file.");
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new PsimiXmlWriterException("Could not create file: " + file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new PsimiXmlWriterException("Could not create file: " + file.getAbsolutePath(), e);
            }
        }
        EntrySet jEntrySet = this.convertInMemory(mEntrySet);
        this.marshall(jEntrySet, file);
    }

    public void write(psidev.psi.mi.xml.model.EntrySet mEntrySet, OutputStream os) throws PsimiXmlWriterException {
        EntrySet jEntrySet = this.convertInMemory(mEntrySet);
        this.marshall(jEntrySet, os);
    }

    public void write(psidev.psi.mi.xml.model.EntrySet mEntrySet, Writer writer) throws IOException, ConverterException, JAXBException, PsimiXmlWriterException {
        EntrySet jEntrySet = this.convertInMemory(mEntrySet);
        this.marshall(jEntrySet, writer);
    }

    public void write(psidev.psi.mi.xml.model.EntrySet mEntrySet, PrintStream ps) throws IOException, ConverterException, JAXBException, PsimiXmlWriterException {
        EntrySet jEntrySet = this.convertInMemory(mEntrySet);
        String xml = this.marshall(jEntrySet);
        ps.println(xml);
    }

    public String getAsString(psidev.psi.mi.xml.model.EntrySet mEntrySet) throws PsimiXmlWriterException {
        EntrySet jEntrySet = this.convertInMemory(mEntrySet);
        String xml = this.marshall(jEntrySet);
        return xml;
    }

    public static String calculateSchemaLocation(int majorVersion, int minorVersion, int bugfix) {
        String versionSuffix = majorVersion > 0 && minorVersion != 0 ? String.valueOf(majorVersion) + String.valueOf(minorVersion) + String.valueOf(bugfix) : "253";
        return "http://psi.hupo.org/mi/mif http://psidev.sourceforge.net/mi/rel25/src/MIF" + versionSuffix + ".xsd";
    }
}

