/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl253;

import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl253.AttributeConverter;
import psidev.psi.mi.xml.converter.impl253.BibrefConverter;
import psidev.psi.mi.xml.converter.impl253.ConfidenceConverter;
import psidev.psi.mi.xml.converter.impl253.CvTypeConverter;
import psidev.psi.mi.xml.converter.impl253.NamesConverter;
import psidev.psi.mi.xml.converter.impl253.OrganismConverter;
import psidev.psi.mi.xml.converter.impl253.XrefConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.FeatureDetectionMethod;
import psidev.psi.mi.xml.model.InteractionDetectionMethod;
import psidev.psi.mi.xml.model.Organism;
import psidev.psi.mi.xml.model.ParticipantIdentificationMethod;
import psidev.psi.mi.xml253.jaxb.AttributeListType;
import psidev.psi.mi.xml253.jaxb.BioSourceType;
import psidev.psi.mi.xml253.jaxb.ConfidenceListType;
import psidev.psi.mi.xml253.jaxb.ExperimentType;

public class ExperimentDescriptionConverter {
    private AttributeConverter attributeConverter = new AttributeConverter();
    private BibrefConverter bibrefConverter = new BibrefConverter();
    private CvTypeConverter cvTypeConverter = new CvTypeConverter();
    private NamesConverter namesConverter = new NamesConverter();
    private ConfidenceConverter confidenceConverter = new ConfidenceConverter();
    private OrganismConverter organismConverter = new OrganismConverter();
    private XrefConverter xrefConverter = new XrefConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
        this.confidenceConverter.setDAOFactory(factory);
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public ExperimentDescription fromJaxb(ExperimentType jExperimentDescription) throws ConverterException {
        if (jExperimentDescription == null) {
            throw new IllegalArgumentException("You must give a non null JAXB ExperimentDescription.");
        }
        this.checkDependencies();
        ExperimentDescription mExperimentDescription = new ExperimentDescription();
        mExperimentDescription.setId(jExperimentDescription.getId());
        if (jExperimentDescription.getNames() != null) {
            mExperimentDescription.setNames(this.namesConverter.fromJaxb(jExperimentDescription.getNames()));
        }
        if (jExperimentDescription.getBibref() != null) {
            mExperimentDescription.setBibref(this.bibrefConverter.fromJaxb(jExperimentDescription.getBibref()));
        }
        if (jExperimentDescription.getXref() != null) {
            mExperimentDescription.setXref(this.xrefConverter.fromJaxb(jExperimentDescription.getXref()));
        }
        if (jExperimentDescription.getHostOrganismList() != null) {
            for (ExperimentType.HostOrganismList.HostOrganism jHostOrganism : jExperimentDescription.getHostOrganismList().getHostOrganisms()) {
                mExperimentDescription.getHostOrganisms().add(this.organismConverter.fromJaxb((BioSourceType)jHostOrganism));
            }
        }
        if (jExperimentDescription.getInteractionDetectionMethod() != null) {
            mExperimentDescription.setInteractionDetectionMethod(this.cvTypeConverter.fromJaxb(jExperimentDescription.getInteractionDetectionMethod(), InteractionDetectionMethod.class));
        }
        if (jExperimentDescription.getParticipantIdentificationMethod() != null) {
            mExperimentDescription.setParticipantIdentificationMethod(this.cvTypeConverter.fromJaxb(jExperimentDescription.getParticipantIdentificationMethod(), ParticipantIdentificationMethod.class));
        }
        if (jExperimentDescription.getFeatureDetectionMethod() != null) {
            mExperimentDescription.setFeatureDetectionMethod(this.cvTypeConverter.fromJaxb(jExperimentDescription.getFeatureDetectionMethod(), FeatureDetectionMethod.class));
        }
        if (jExperimentDescription.getConfidenceList() != null) {
            for (ConfidenceListType.Confidence jConfidence : jExperimentDescription.getConfidenceList().getConfidences()) {
                mExperimentDescription.getConfidences().add(this.confidenceConverter.fromJaxb(jConfidence));
            }
        }
        if (jExperimentDescription.getAttributeList() != null) {
            for (AttributeListType.Attribute jAttribute : jExperimentDescription.getAttributeList().getAttributes()) {
                mExperimentDescription.getAttributes().add(this.attributeConverter.fromJaxb(jAttribute));
            }
        }
        PsiDAO<ExperimentDescription> experimentDAO = this.factory.getExperimentDAO();
        experimentDAO.store(mExperimentDescription);
        return mExperimentDescription;
    }

    public ExperimentType toJaxb(ExperimentDescription mExperimentDescription) throws ConverterException {
        if (mExperimentDescription == null) {
            throw new IllegalArgumentException("You must give a non null model ExperimentDescription.");
        }
        this.checkDependencies();
        ExperimentType jExperimentDescription = new ExperimentType();
        jExperimentDescription.setId(mExperimentDescription.getId());
        if (mExperimentDescription.getNames() != null) {
            jExperimentDescription.setNames(this.namesConverter.toJaxb(mExperimentDescription.getNames()));
        }
        if (mExperimentDescription.getBibref() != null) {
            jExperimentDescription.setBibref(this.bibrefConverter.toJaxb(mExperimentDescription.getBibref()));
        }
        if (mExperimentDescription.hasXref()) {
            jExperimentDescription.setXref(this.xrefConverter.toJaxb(mExperimentDescription.getXref()));
        }
        for (Organism mOrganism : mExperimentDescription.getHostOrganisms()) {
            if (jExperimentDescription.getHostOrganismList() == null) {
                jExperimentDescription.setHostOrganismList(new ExperimentType.HostOrganismList());
            }
            jExperimentDescription.getHostOrganismList().getHostOrganisms().add(this.organismConverter.toJaxb(mOrganism, ExperimentType.HostOrganismList.HostOrganism.class));
        }
        if (mExperimentDescription.getInteractionDetectionMethod() != null) {
            jExperimentDescription.setInteractionDetectionMethod(this.cvTypeConverter.toJaxb(mExperimentDescription.getInteractionDetectionMethod()));
        }
        if (mExperimentDescription.getParticipantIdentificationMethod() != null) {
            jExperimentDescription.setParticipantIdentificationMethod(this.cvTypeConverter.toJaxb(mExperimentDescription.getParticipantIdentificationMethod()));
        }
        if (mExperimentDescription.getFeatureDetectionMethod() != null) {
            jExperimentDescription.setFeatureDetectionMethod(this.cvTypeConverter.toJaxb(mExperimentDescription.getFeatureDetectionMethod()));
        }
        for (Confidence mConfidence : mExperimentDescription.getConfidences()) {
            if (jExperimentDescription.getConfidenceList() == null) {
                jExperimentDescription.setConfidenceList(new ConfidenceListType());
            }
            jExperimentDescription.getConfidenceList().getConfidences().add(this.confidenceConverter.toJaxb(mConfidence));
        }
        for (Attribute mAttribute : mExperimentDescription.getAttributes()) {
            if (jExperimentDescription.getAttributeList() == null) {
                jExperimentDescription.setAttributeList(new AttributeListType());
            }
            jExperimentDescription.getAttributeList().getAttributes().add(this.attributeConverter.toJaxb(mAttribute));
        }
        return jExperimentDescription;
    }
}

