/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model.builder;

import psidev.psi.mi.tab.utils.MitabEscapeUtils;

public final class Field {
    private static final String COLON = ":";
    private static final String OPEN_BRACKET = "(";
    private static final String CLOSE_BRACKET = ")";
    private String type;
    private String value;
    private String description;

    public Field(String value) {
        this(null, value, null);
    }

    public Field(String type, String value) {
        this(type, value, null);
    }

    public Field(String type, String value, String description) {
        this.type = type;
        this.value = value;
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            sb.append(MitabEscapeUtils.escapeFieldElement(this.type));
            sb.append(COLON);
        }
        if (this.value != null) {
            if (this.type == null && this.description == null) {
                sb.append(this.value);
            } else {
                sb.append(MitabEscapeUtils.escapeFieldElement(this.value));
            }
        }
        if (this.description != null) {
            sb.append(OPEN_BRACKET);
            sb.append(MitabEscapeUtils.escapeFieldElement(this.description));
            sb.append(CLOSE_BRACKET);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field that = (Field)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }
}

