/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model.builder;

import java.util.LinkedList;
import java.util.List;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.builder.ColumnDefinition;
import psidev.psi.mi.tab.model.builder.InteractionRowConverter;
import psidev.psi.mi.tab.model.builder.Row;
import psidev.psi.mi.tab.model.builder.RowBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentDefinition<T extends BinaryInteraction> {
    private List<ColumnDefinition> columnDefinitions = new LinkedList<ColumnDefinition>();

    protected void addColumnDefinition(ColumnDefinition columnDefinition) {
        this.columnDefinitions.add(columnDefinition);
    }

    public ColumnDefinition getColumnDefinition(int i) {
        return this.columnDefinitions.get(i);
    }

    public int getColumnDefinitionCount() {
        return this.columnDefinitions.size();
    }

    public RowBuilder createRowBuilder() {
        return new RowBuilder(this);
    }

    public int getColumnsCount() {
        return this.columnDefinitions.size();
    }

    public abstract InteractionRowConverter<T> createInteractionRowConverter();

    public String interactionToString(T binaryInteraction) {
        return this.createInteractionRowConverter().createRow(binaryInteraction).toString();
    }

    public T interactionFromString(String str) {
        Row row = this.createRowBuilder().createRow(str);
        return this.createInteractionRowConverter().createBinaryInteraction(row);
    }

    public ColumnDefinition getColumnDefinitionByShortName(String shortName) {
        for (ColumnDefinition colDef : this.columnDefinitions) {
            if (!shortName.equals(colDef.getShortName())) continue;
            return colDef;
        }
        return null;
    }
}

