/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model.builder;

import java.util.LinkedList;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.builder.Column;
import psidev.psi.mi.tab.model.builder.InteractionRowConverter;
import psidev.psi.mi.tab.model.builder.ParseUtils;
import psidev.psi.mi.tab.model.builder.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInteractionRowConverter<T extends BinaryInteraction>
implements InteractionRowConverter<T> {
    protected abstract T newBinaryInteraction(Interactor var1, Interactor var2);

    protected abstract Interactor newInteractor();

    @Override
    public T createBinaryInteraction(Row row) {
        if (row.getColumnCount() < 15) {
            throw new IllegalArgumentException("At least 15 columns were expected in row: " + row);
        }
        T binaryInteraction = this.newBinaryInteraction(this.createInteractorA(row), this.createInteractorB(row));
        this.populateBinaryInteraction((BinaryInteraction)binaryInteraction, row);
        return binaryInteraction;
    }

    @Override
    public Row createRow(T interaction) {
        LinkedList<Column> columns = new LinkedList<Column>();
        Object interactorA = interaction.getInteractorA();
        Object interactorB = interaction.getInteractorB();
        columns.add(ParseUtils.createColumnFromCrossReferences(((Interactor)interactorA).getIdentifiers()));
        columns.add(ParseUtils.createColumnFromCrossReferences(((Interactor)interactorB).getIdentifiers()));
        columns.add(ParseUtils.createColumnFromCrossReferences(((Interactor)interactorA).getAlternativeIdentifiers()));
        columns.add(ParseUtils.createColumnFromCrossReferences(((Interactor)interactorB).getAlternativeIdentifiers()));
        columns.add(ParseUtils.createColumnFromAliases(((Interactor)interactorA).getAliases()));
        columns.add(ParseUtils.createColumnFromAliases(((Interactor)interactorB).getAliases()));
        columns.add(ParseUtils.createColumnFromDetectionMethods(interaction.getDetectionMethods()));
        columns.add(ParseUtils.createColumnFromAuthors(interaction.getAuthors()));
        columns.add(ParseUtils.createColumnFromCrossReferences(interaction.getPublications()));
        columns.add(ParseUtils.createColumnFromOrganism(((Interactor)interactorA).getOrganism()));
        columns.add(ParseUtils.createColumnFromOrganism(((Interactor)interactorB).getOrganism()));
        columns.add(ParseUtils.createColumnFromInteractionTypes(interaction.getInteractionTypes()));
        columns.add(ParseUtils.createColumnFromCrossReferences(interaction.getSourceDatabases()));
        columns.add(ParseUtils.createColumnFromCrossReferences(interaction.getInteractionAcs()));
        columns.add(ParseUtils.createColumnFromConfidences(interaction.getConfidenceValues()));
        return new Row(columns);
    }

    protected Interactor createInteractorA(Row row) {
        Column idACol = row.getColumnByIndex(0);
        Column altidACol = row.getColumnByIndex(2);
        Column aliasACol = row.getColumnByIndex(4);
        Column taxidACol = row.getColumnByIndex(9);
        Interactor interactorA = this.newInteractor();
        interactorA.setIdentifiers(ParseUtils.createCrossReferences(idACol));
        interactorA.setAlternativeIdentifiers(ParseUtils.createCrossReferences(altidACol));
        interactorA.setAliases(ParseUtils.createAliases(aliasACol));
        interactorA.setOrganism(ParseUtils.createOrganism(taxidACol));
        return interactorA;
    }

    protected Interactor createInteractorB(Row row) {
        Column idBCol = row.getColumnByIndex(1);
        Column altidBCol = row.getColumnByIndex(3);
        Column aliasBCol = row.getColumnByIndex(5);
        Column taxidBCol = row.getColumnByIndex(10);
        Interactor interactorB = this.newInteractor();
        interactorB.setIdentifiers(ParseUtils.createCrossReferences(idBCol));
        interactorB.setAlternativeIdentifiers(ParseUtils.createCrossReferences(altidBCol));
        interactorB.setAliases(ParseUtils.createAliases(aliasBCol));
        interactorB.setOrganism(ParseUtils.createOrganism(taxidBCol));
        return interactorB;
    }

    protected void populateBinaryInteraction(BinaryInteraction binaryInteraction, Row row) {
        Column intDetMethodCol = row.getColumnByIndex(6);
        Column pubAuthCol = row.getColumnByIndex(7);
        Column pubIdCol = row.getColumnByIndex(8);
        Column intTypeCol = row.getColumnByIndex(11);
        Column sourceDbCol = row.getColumnByIndex(12);
        Column intIdCol = row.getColumnByIndex(13);
        Column confCol = row.getColumnByIndex(14);
        binaryInteraction.setDetectionMethods(ParseUtils.createInteractionDetectionMethods(intDetMethodCol));
        binaryInteraction.setAuthors(ParseUtils.createAuthors(pubAuthCol));
        binaryInteraction.setPublications(ParseUtils.createCrossReferences(pubIdCol));
        binaryInteraction.setInteractionTypes(ParseUtils.createInteractionTypes(intTypeCol));
        binaryInteraction.setSourceDatabases(ParseUtils.createCrossReferences(sourceDbCol));
        binaryInteraction.setInteractionAcs(ParseUtils.createCrossReferences(intIdCol));
        binaryInteraction.setConfidenceValues(ParseUtils.createConfidenceValues(confCol));
    }
}

