/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model;

import java.util.Collection;
import java.util.Collections;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.ForbiddenOperationException;
import psidev.psi.mi.tab.model.Organism;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableOrganism
implements Organism {
    private Organism organism;

    public UnmodifiableOrganism(Organism organism) {
        if (organism == null) {
            throw new IllegalArgumentException("You must give a non null organism");
        }
        this.organism = organism;
    }

    @Override
    public Collection<CrossReference> getIdentifiers() {
        return Collections.unmodifiableCollection(this.organism.getIdentifiers());
    }

    @Override
    public String getTaxid() {
        return this.organism.getTaxid();
    }

    @Override
    public void addIdentifier(CrossReference ref) {
        throw new ForbiddenOperationException("If you need to alter Organism, you should disable Organism pooling.");
    }

    @Override
    public void setIdentifiers(Collection<CrossReference> identifiers) {
        this.organism.setIdentifiers(identifiers);
    }
}

