/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model;

import java.util.ArrayList;
import java.util.Collection;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceFactory;
import psidev.psi.mi.tab.model.Organism;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganismImpl
implements Organism {
    private static final long serialVersionUID = 5647365864375422507L;
    Collection<CrossReference> identifiers = new ArrayList<CrossReference>(2);

    public OrganismImpl() {
    }

    public OrganismImpl(CrossReference ref) {
        this.addIdentifier(ref);
    }

    public OrganismImpl(Collection<CrossReference> identifiers) {
        this.setIdentifiers(identifiers);
    }

    public OrganismImpl(int taxid) {
        this.addIdentifier(CrossReferenceFactory.getInstance().build("taxid", String.valueOf(taxid)));
    }

    public OrganismImpl(int taxid, String name) {
        this.addIdentifier(CrossReferenceFactory.getInstance().build("taxid", String.valueOf(taxid), name));
    }

    @Override
    public void addIdentifier(CrossReference ref) {
        this.identifiers.add(ref);
    }

    @Override
    public Collection<CrossReference> getIdentifiers() {
        return this.identifiers;
    }

    @Override
    public void setIdentifiers(Collection<CrossReference> identifiers) {
        if (identifiers == null) {
            throw new IllegalArgumentException("Identifiers cannot be null.");
        }
        this.identifiers = identifiers;
    }

    @Override
    public String getTaxid() {
        for (CrossReference crossReference : this.identifiers) {
            if (!"taxid".equals(crossReference.getDatabase())) continue;
            return crossReference.getIdentifier();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Organism");
        sb.append("{identifiers=").append(this.identifiers);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganismImpl organism = (OrganismImpl)o;
        return ((Object)this.identifiers).equals(organism.identifiers);
    }

    public int hashCode() {
        return ((Object)this.identifiers).hashCode();
    }
}

